---
name: music-playlist-curator
version: 1.0.0
description: Master music playlist curator that creates mood-based, activity-based, and genre-based playlists with BPM matching, key-compatible transitions, energy arc design, and artist discovery reasoning for any occasion
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a professional music playlist curator that goes beyond listing good songs. It understands:

- **Playlist architecture**: Openers, momentum builders, anchors, peaks, closers
- **Energy arc design**: Steady state, warm-up build, peak-and-valley, wind-down, wave, crescendo
- **BPM and key matching**: Camelot wheel harmonic mixing, tempo transitions within 3-8 BPM
- **Activity optimization**: Specialized templates for workout, study, party, road trip, dinner, coding, sleep, morning
- **Genre deep dives**: Characteristics, BPM ranges, and cross-genre bridging for 20+ genres
- **Discovery methodology**: Five levels from sonic similarity to emotional fingerprinting
- **Era-based curation**: Decade-specific sound palettes from 1960s to 2020s
- **Seasonal and time-of-day awareness**: Contextually appropriate selections

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
music-playlist-curator/
├── SKILL.md          # Main playlist curation instructions
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill - simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r music-playlist-curator/ ~/.claude/skills/music-playlist-curator/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Start requesting curated playlists

## Usage Examples

### Activity-Based Playlist

```
User: I need a playlist for a 45-minute morning run. I usually run at about
an 8:30 pace. I like hip-hop and electronic but open to anything with energy.

AI:
YOUR CURATED PLAYLIST
═══════════════════════════

PLAYLIST: Morning Run — 45 Minutes
PURPOSE: Running at 8:30/mi pace (~165 SPM)
DURATION: ~47m (12 tracks)
ENERGY ARC: Warm-up build → sustained peak → cool down
GENRE MIX: Hip-hop and electronic with touches of pop and dance

── TRACKLIST ────────────────────────────────

## Warm-Up — BPM 110-130

 1. Levitating — Dua Lipa                  103 BPM  Med
    → Easy start, infectious groove, gets you moving without pushing

 2. HUMBLE. — Kendrick Lamar               150 BPM  Med-High
    → Energy steps up, the beat locks into your stride

 3. Midnight City — M83                     105 BPM  Med-High
    → Synth build bridges to peak section, anthemic energy

## Peak — BPM 140-170

 4. Stronger — Kanye West                   104 BPM  High
    → Daft Punk sample = instant motivation, half-time feel at running pace

 5. Titanium — David Guetta ft. Sia         126 BPM  High
    → Massive drop aligns with pushing through the wall

[... continues ...]

── DISCOVERY HIGHLIGHTS ─────────────────────

NEW ARTISTS TO EXPLORE:
• Shygirl: UK electronic with hip-hop energy, perfect running BPM
• Peggy Gou: Korean-German DJ, her track "It Makes You Forget" has infectious groove
```

### Mood-Based Playlist

```
User: Rainy Sunday afternoon. I'm reading and drinking tea. Something warm
and gentle. I like Norah Jones and Bon Iver.

AI:
YOUR CURATED PLAYLIST
═══════════════════════════

PLAYLIST: Rainy Sunday Pages
PURPOSE: Reading companion, warm and intimate
DURATION: ~1h 30m (20 tracks)
ENERGY ARC: Steady state, gentle warmth throughout
GENRE MIX: Jazz-folk-ambient blend anchored by your taste

── TRACKLIST ────────────────────────────────

## Setting the Scene — BPM 65-75

 1. Don't Know Why — Norah Jones             72 BPM  Low
    → Opens with a familiar anchor, warm piano sets the tone

 2. Skinny Love — Bon Iver                   69 BPM  Low
    → Emotional intimacy matches the mood, acoustic bridge

 3. River — Leon Bridges                      73 BPM  Low
    → Neo-soul warmth connects jazz and folk elements

DISCOVERY NOTE — Leon Bridges:
"If you love Norah Jones's warmth and Bon Iver's emotion,
Leon Bridges sits right between them. His album 'Coming Home'
was recorded on vintage equipment for authentic analog warmth."

[... continues ...]
```

### Event-Based Playlist

```
User: Hosting a dinner party for 8 people, ages 30-50. Cooking starts at 6pm,
guests arrive 7pm, dinner at 8pm, lingering after. I like jazz and soul.
Keep it classy but not stuffy.

AI:
YOUR CURATED PLAYLIST
═══════════════════════════

PLAYLIST: Saturday Supper Club
PURPOSE: Dinner party with evolving phases
DURATION: ~3h 30m (42 tracks)
ENERGY ARC: Wave — active cooking → sophisticated arrival → intimate dinner → social after
GENRE MIX: Jazz and soul with bossa nova, neo-soul, and modern touches

── TRACKLIST ────────────────────────────────

## Kitchen Dance — BPM 105-120

 1. Le Freak — Chic                         120 BPM  Med-High
    → Cooking deserves fun energy, disco-funk gets you moving at the stove

 2. Lovely Day — Bill Withers               100 BPM  Med
    → Positive energy, everyone knows it, sets a warm tone

[... continues through all four phases ...]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{mood_or_activity}}` | chill evening at home | The mood, vibe, or activity the playlist supports |
| `{{genre_preferences}}` | open to anything | Preferred genres or artists as anchors |
| `{{energy_level}}` | dynamic | Energy arc: low, medium, high, or dynamic |
| `{{playlist_length}}` | 20 songs | Number of songs or target duration |
| `{{discovery_appetite}}` | some_discovery | familiar_only, some_discovery, or mostly_new |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot

## Tips for Best Results

1. **Describe the scene**: "Rainy Sunday reading" works better than "chill music"
2. **Name anchor artists**: Give 2-3 artists you love so the curator can build around your taste
3. **Specify the energy arc**: For events, describe the timeline (arrival at 7, dinner at 8, etc.)
4. **Set discovery appetite**: Familiar comfort or new exploration — the curator adjusts the ratio
5. **Mention constraints**: Instrumental only, no explicit lyrics, specific decades, etc.
6. **Ask for BPM matching**: If you know your running cadence or preferred workout tempo, say so
7. **Request genre bridges**: "Start with jazz and end up at electronic" for adventurous curation

## Key Features

- **8 activity templates**: Workout, study, party, road trip, relaxation, dinner, coding, morning
- **20+ genre profiles**: BPM ranges, energy levels, transition compatibility for each genre
- **Camelot wheel integration**: Harmonic key matching for smooth transitions between tracks
- **5-level discovery system**: From sonic similarity to emotional fingerprinting
- **Era-aware curation**: Decade-specific sound palettes from 1960s through 2020s
- **Seasonal awareness**: Spring brightness, summer energy, autumn warmth, winter intimacy
- **Track placement roles**: Opener, builders, anchor, explorers, peak, comedown, closer

---
Downloaded from [FindSkill.ai](https://findskill.ai)
