---
name: tabletop-rpg-character-builder
version: 1.0.0
description: Build TTRPG player characters with deep backstories, optimized builds, character voice, and level-up plans for D&D 5e, Pathfinder 2e, Call of Cthulhu 7e, Fate Core, and other systems
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a comprehensive tabletop RPG player character builder. It produces complete, session-ready characters with 12 structured sections covering mechanics, narrative, and table presence. Supports multiple RPG systems with system-specific build guidance. Features include:

- Multi-system support (D&D 5e, Pathfinder 2e, Call of Cthulhu 7e, Fate Core)
- Character creation philosophy balancing story-first and mechanics-first approaches
- System-specific builds with race/class combos, feat roadmaps, spell selection, and multiclass analysis
- Structured backstory framework (origin, defining moment, motivation, flaw, connections, secret)
- Character voice development with speech patterns, catchphrases, and sample dialogue
- Party role analysis identifying gaps, synergies, and tactical combos
- Build optimization tailored to party role with stat, feat, and spell priorities
- Roleplaying hooks with moral dilemmas, growth arcs, and trigger moments
- Character sheet quick-fill with all mechanical values ready for sheet transfer
- Level-up roadmap mapping key decisions and power spikes
- Retirement/legacy planning with satisfying endings and successor concepts
- Session zero preparation with pitch, DM/player needs, and table expectations
- Archetype inspiration drawing from literature, mythology, and history

**Time to initialize**: ~30 seconds (prompt-only skill)

## Directory Structure

```
tabletop-rpg-character-builder/
├── SKILL.md          # Main character building instructions and frameworks
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill -- simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r tabletop-rpg-character-builder/ ~/.claude/skills/tabletop-rpg-character-builder/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Answer the five setup questions or say "Surprise me with a [system] character"

## Usage Examples

### D&D 5e Character Build (Balanced Priority)

```
User: Build me a D&D 5e character. I want to play a haunted detective --
someone who investigates supernatural crimes and got too close to something
dangerous. The party has a barbarian and a cleric. I want story and mechanics
equally. Forgotten Realms, starting at level 3.

AI:
+================================================================+
|  CHARACTER: Aldric Voss                                         |
|  Also Known As: "The Lantern Man"                              |
+================================================================+
|  System: D&D 5e         Level: 3                                |
|  Race: Variant Human    Class: Warlock (The Undead Patron)      |
|  Background: Investigator                                       |
|  Alignment: Lawful Neutral                                      |
|  Age: 38    Gender: Male    Pronouns: He/Him                   |
+================================================================+
|  Player Pitch:                                                   |
|  "A former city detective who made a pact with the ghost of his |
|   murdered partner to hunt the thing that killed her."          |
+================================================================+

[...full 12-section character profile follows...]
```

### Pathfinder 2e Character (Mechanics Priority)

```
User: PF2e character, mechanics priority. We're running free archetype
variant. Party has a champion and a bard. I want to be the main damage
dealer. Level 1, Golarion, Age of Ashes AP.

AI:
+================================================================+
|  CHARACTER: Kessara Thornblaze                                   |
|  Also Known As: "Thorn"                                         |
+================================================================+
|  System: Pathfinder 2e   Level: 1                                |
|  Ancestry: Orc (Hold-Scarred Heritage)                           |
|  Class: Ranger (Flurry Edge)                                     |
|  Background: Farmhand                                            |
|  Alignment: Neutral                                              |
+================================================================+

[...full build with feat roadmaps, archetype dedication plan,
   skill allocation, and damage optimization...]
```

### Call of Cthulhu Investigator (Story Priority)

```
User: Call of Cthulhu character, story priority. 1920s classic era.
I want to play a journalist who stumbled onto something at a society
gala. Other investigators are a professor and a private eye.

AI:
INVESTIGATOR PROFILE
====================
OCCUPATION: Journalist
ERA: 1920s Classic

Name: Miriam Blackwell
Age: 29
Residence: Boston, Massachusetts

[...full investigator with backstory connections, Luck strategy,
   skill allocation, and roleplaying hooks tied to the Mythos...]
```

### Quick Random Character

```
User: Surprise me with a D&D 5e character. Any concept, any race.
Make it interesting.

AI: [Randomly generates concept, race, class, backstory, and full
12-section profile with unexpected but cohesive character choices]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{rpg_system}}` | dnd5e | RPG system: dnd5e, pathfinder2e, call_of_cthulhu, fate, other |
| `{{character_concept}}` | wandering scholar seeking forbidden knowledge | Brief concept or archetype description |
| `{{party_composition}}` | unknown | Other party members' classes/roles, or "unknown" |
| `{{optimization_priority}}` | balanced | Focus: story (narrative depth), mechanics (power/synergy), balanced (both) |
| `{{campaign_setting}}` | homebrew fantasy | Campaign world: Forgotten Realms, Golarion, 1920s New England, homebrew, etc. |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot
- Llama 3 (70B+)
- Mistral Large

## Tips for Best Results

1. **Specify your system**: Build sections are completely different between D&D 5e, Pathfinder 2e, and Call of Cthulhu -- be explicit
2. **Share party composition**: Knowing existing roles produces dramatically better build and role recommendations
3. **Be honest about priority**: "Mechanics" is a valid answer -- there is no wrong way to play
4. **Mention campaign tone**: A horror investigation demands a different character than a heroic epic
5. **Provide starting level**: Level 1 builds look very different from level 5 or level 10 entry points
6. **Use the session zero prep**: The 30-second pitch alone is worth the build -- practice it before game day
7. **Revisit the level-up roadmap**: Check back before each level-up to stay on track with the plan
8. **Pair with the NPC Generator**: Use the D&D NPC Generator skill to create NPCs tied to your character's backstory (mentors, enemies, family)

## Section Reference

| Section | Content | Story Focus | Balanced | Mech Focus |
|---------|---------|:-:|:-:|:-:|
| 1. Identity Card | Name, class, race, pitch | Full | Full | Full |
| 2. System Build | Race, class, feats, spells, multiclass | Standard | Full | Max |
| 3. Backstory | Origin, moment, motivation, flaw, secret | Max | Full | Standard |
| 4. Character Voice | Speech, mannerisms, catchphrases, dialogue | Max | Full | Standard |
| 5. Party Role | Gap analysis, synergies, dynamics | Standard | Full | Max |
| 6. Role Optimization | Stats, feats, spells, tactics by role | Standard | Full | Max |
| 7. RP Hooks | Dilemmas, growth arcs, triggers | Max | Full | Standard |
| 8. Sheet Quick-Fill | All mechanical values for the sheet | Full | Full | Full |
| 9. Level-Up Roadmap | Decisions, power spikes, long-term goal | Standard | Full | Max |
| 10. Retirement | Endings, legacy, successor | Max | Full | Standard |
| 11. Session Zero | Pitch, DM/player needs, expectations | Max | Full | Standard |
| 12. Archetype | Literary, mythological, historical roots | Max | Full | Standard |

## Differences from D&D NPC Generator

This skill builds **player characters** -- the heroes that players roleplay at the table. It covers mechanical optimization, level-up planning, and personal voice development that NPCs do not need. The [D&D NPC Generator](https://findskill.ai/skills/gaming-entertainment/dnd-npc-generator/) builds **non-player characters** for Dungeon Masters, with stat blocks, quest hooks, and disposition tracking designed for DM use. The two skills complement each other: build your PC here, then ask the DM to populate the world with the NPC generator.

---
Downloaded from [FindSkill.ai](https://findskill.ai)
