---
name: trivia-game-night-creator
version: 1.0.0
description: Generate custom trivia questions, party games, icebreakers, and entertainment for gatherings
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you create memorable game nights by generating custom trivia questions, icebreaker games, party activities, and complete entertainment packages tailored to your specific gathering.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
trivia-game-night-creator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None required - this is a prompt-only skill.

## Files to Generate

None - this skill works by copying the SKILL.md content directly to your AI assistant.

## What This Skill Creates

When you use this skill, you can generate:

### Trivia Content
- Custom trivia rounds (10-20 questions each)
- Multiple difficulty levels (Easy/Medium/Hard)
- 15+ category options (Pop Culture, History, Science, Sports, etc.)
- Themed rounds (decades, holidays, specific topics)
- Picture and audio round suggestions
- Answer keys with fun facts

### Icebreaker Games
- Two Truths and a Lie
- Would You Rather questions
- This or That rapid fire
- Human Bingo cards
- Speed networking formats
- Story chain starters

### Party Games
- Charades with custom categories
- Fishbowl (3-round format)
- Taboo word lists
- Minute to Win It challenges
- Team building activities
- Social deduction games (Mafia/Werewolf)

### Complete Packages
- 2-3 hour trivia night schedules
- Party games mix formats
- Family game night templates
- Office team building programs
- Scoring systems and rules

## Post-Init Steps

### For Claude Code
```bash
# Copy to your skills directory
cp -r trivia-game-night-creator/ ~/.claude/skills/trivia-game-night-creator/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Describe your event and let the AI create your custom game night

## Usage Examples

### Example 1: Trivia Night
```
Create a trivia night for 16 people (4 teams of 4). We want 5 rounds
of 10 questions each covering: 90s music, Marvel movies, food & drink,
geography, and a "random" mixed round. Include a wager-style final question.
```

### Example 2: Office Team Building
```
I need a 90-minute team building session for 25 coworkers.
We work in tech, ages 25-45. I want icebreakers to start,
some trivia, and a collaborative challenge. Keep it work-appropriate.
```

### Example 3: Family Game Night
```
Planning a game night for my family - 8 people ranging from
age 10 to 70. Need about 2 hours of activities that everyone
can participate in. Include some physical games but nothing
too strenuous for grandparents.
```

### Example 4: Themed Party
```
I'm hosting a 90s themed birthday party for my friend who's
turning 40. About 20 guests, all grew up in the 90s.
Create a full package: 90s trivia, themed party games,
and some icebreakers that tap into 90s nostalgia.
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{event_type}}` | casual game night | Type of gathering |
| `{{group_size}}` | 8-12 people | Number of participants |
| `{{age_range}}` | adults (21+) | Age range of attendees |
| `{{difficulty_level}}` | mixed | Easy, Medium, Hard, or Mixed |
| `{{theme}}` | general | Specific theme or decade |
| `{{duration}}` | 2 hours | How long the event lasts |

## Compatibility

Tested with:
- Claude (claude.ai)
- ChatGPT (chat.openai.com)
- Gemini (gemini.google.com)
- Microsoft Copilot

## Tips for Best Results

1. **Be specific about your group**: The more details you provide about attendees (ages, interests, relationships), the better the customization.

2. **Mention any topics to avoid**: If there are sensitive subjects for your group, let the AI know upfront.

3. **Request full packages**: Ask for complete game nights with schedules, not just individual questions.

4. **Include context**: Mention if it's a special occasion, work event, or casual gathering.

5. **Ask for alternatives**: Request backup games in case something doesn't land with the group.

---
Downloaded from [FindSkill.ai](https://findskill.ai)
