---
name: worldbuilding-encyclopedia
version: 1.0.0
description: Worldbuilding Encyclopedia for games, novels, and TTRPGs. Builds internally consistent fictional worlds covering geography, politics, culture, economics, magic/technology systems, religion, language, history, ecology, social structures, and conflict. Includes a Consistency Engine for cross-referencing elements and standardized encyclopedia entry format.
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a systematic worldbuilding partner that constructs internally consistent fictional worlds. It applies real-world principles from geography, anthropology, political science, economics, linguistics, ecology, and religious studies to fictional settings. Key capabilities:

- Geographic foundations with tectonic logic, climate zones, ocean currents, and biome mapping
- Political systems (monarchy, theocracy, democracy, tribal, corporate, magical) with inter-polity relationships
- Cultural development derived from environment, history, and values
- Functional economies with currency, trade routes, guilds, class structures, and resource distribution
- Magic/technology systems using Sanderson's Laws with second-order effects tracing
- Religion and mythology with creation myths, pantheons, practices, clergy, and heresies
- Language and naming conventions with phonological palettes and linguistic evolution
- Historical timelines with era progression, rise and fall of civilizations, and population dynamics
- Ecology with food webs, creature design, domesticated animals, and magical ecosystems
- Social structures covering family, education, justice, and coming-of-age systems
- Conflict driver framework across territorial, resource, religious, ideological, magical, and internal axes
- Consistency Engine that cross-references every element and flags contradictions
- Standardized encyclopedia entry format with cross-references and narrative hooks

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
worldbuilding-encyclopedia/
├── SKILL.md          # Main worldbuilding instructions and frameworks
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill -- use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r worldbuilding-encyclopedia/ ~/.claude/skills/worldbuilding-encyclopedia/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Describe the world you want to build

## Usage Examples

### Building a Continent from Scratch

```
User: I'm creating a fantasy continent for a D&D campaign. Three major
civilizations: a maritime empire, nomadic steppe people, and a mountain
theocracy. Magic is rare and dangerous. Start with geography and climate,
then derive the rest.

AI: [Produces tectonic foundations, ocean currents determining climate,
three geographic regions matching the civilizations, trade routes following
rivers and coastlines, resource distribution creating inter-polity
dependencies, then derives cultures, politics, and economics from the
geographic foundation]
```

### Designing a Magic System

```
User: I need a hard magic system for a steampunk world. Magic is powered
by refined aetherium crystals. I want clear rules, costs, and limitations
that affect society. Apply Sanderson's Laws.

AI: [Designs source (environmental/technological), fuel (aetherium crystals
with mining, refinement, and scarcity dynamics), 5+ hard limitations, full
societal impact analysis including military use, economic effects, class
structure, and legal framework. Traces second-order effects: if aetherium
powers healing, how does that change hospitals? If it powers transport,
how does that change trade routes?]
```

### Cross-Referencing Existing Lore

```
User: I have an existing world with these details [pastes 2 pages of notes].
Check it for internal consistency and fill in the gaps.

AI: [Runs Consistency Engine across all elements, flags 3-5 potential
contradictions with explanations, identifies 5-10 gaps that need development,
suggests resolutions for contradictions, and produces encyclopedia entries
for the gaps with full cross-references to existing material]
```

### Creating a Culture from Environment

```
User: I have a desert culture living around a network of oases connected
by underground rivers. They herd giant beetles and trade rare spices.
Build out their full culture.

AI: [Derives values from environment (water stewardship, hospitality code,
underground navigation), customs (water-sharing ceremonies, beetle bonding
rituals, spice festivals), art (sand painting, water music, beetle carapace
carving), food culture (beetle milk, spice-preserved foods, fermented cactus),
clothing (sand-resistant, heat-reflecting), taboos (wasting water, harming
beetles), political structure (oasis council), and religion (water goddess,
beetle spirit, underground ancestors)]
```

### Building a Historical Timeline

```
User: I need 3000 years of history for a world where an ancient magical
civilization collapsed 1000 years ago. Current nations formed from its
fragments. Show how the past explains the present.

AI: [Creates 5-7 eras from the ancient empire's golden age through its
collapse, dark age, recovery, and present. Each era gets key events,
dominant powers, cultural character, and legacy. Current political tensions
traced to specific historical events. Ruins and artifacts from the ancient
civilization placed with geographic and narrative logic. Population dynamics
tracked across eras.]
```

### Village-Scale Deep Dive

```
User: I need a complete village for the starting point of my campaign.
Fishing village on a river delta, population about 200, with a dark secret.

AI: [Creates every building, 15-20 named NPCs with relationships, local
map, seasonal calendar, economy (fishing, river trade, salt production),
local customs, religious shrine, justice system, 3 layers of secrets
(village gossip, hidden tensions, the dark secret), and 5+ adventure hooks
all cross-referenced to the broader world]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{world_genre}}` | fantasy | Genre of the world being built |
| `{{scale}}` | continent | Geographic scope (continent, kingdom, city, village, multi-world) |
| `{{detail_level}}` | comprehensive | Depth of encyclopedia entries (overview, standard, comprehensive, exhaustive) |
| `{{existing_lore}}` | none | Existing worldbuilding to integrate, or "none" for fresh start |
| `{{focus_area}}` | general | Primary domain to prioritize (geography, politics, culture, economics, magic, religion, language, history, ecology, social) |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot
- Llama 3 (70B+)
- Mistral Large

## Tips for Best Results

1. **Start with geography**: Everything else derives from the physical world. Climate shapes culture, resources shape economy, terrain shapes politics.
2. **Define magic limitations first**: What magic CANNOT do is more important than what it can. Limitations create interesting worlds.
3. **Use the Consistency Engine**: After every major addition, ask the AI to check for contradictions against existing entries.
4. **Work iteratively**: Build broad strokes first, then zoom into areas that matter most for your story or campaign.
5. **Let cultures emerge from environment**: Do not invent cultures in isolation. Ask "what would people living HERE value, eat, wear, and believe?"
6. **Trace second-order effects**: If your world has healing magic, teleportation, or any powerful element, ask "how does this change medicine, trade, warfare, and daily life?"
7. **Cross-reference obsessively**: The connections between elements create the feeling of a living world. Every entry should reference at least 3 others.
8. **Use the encyclopedia entry format**: Standardized entries make it easy to find information later and ensure nothing is half-developed.
9. **History explains the present**: Every current tension should have roots in the timeline. Ask "why is this conflict happening NOW?"
10. **Scale your detail level**: Do not write exhaustive entries for every village on the continent. Match detail to narrative importance.

## Supported World Types

- High Fantasy (Tolkien, Sanderson, Jordan)
- Low/Dark Fantasy (Abercrombie, Martin, Sapkowski)
- Science Fiction (hard, space opera, cyberpunk, solarpunk)
- Post-Apocalyptic (nuclear, magical, ecological, plague)
- Steampunk / Clockpunk / Dieselpunk
- Modern Supernatural / Urban Fantasy
- Historical Fantasy (real history + magical elements)
- Weird West / Frontier Fantasy
- Planetary Romance / Dying Earth
- Cosmic Horror / Lovecraftian
- Mythic (based on real-world mythologies)
- Multi-genre hybrid settings

## Key References

This skill draws from established worldbuilding principles including:
- Brandon Sanderson's Three Laws of Magic (hard/soft magic system design)
- Mark Rosenfelder's *The Language Construction Kit* (conlang and naming)
- Jared Diamond's *Guns, Germs, and Steel* (geographic determinism in civilization)
- Worldbuilding Magazine community resources
- World Anvil's cross-referencing and consistency frameworks
- Real-world geography, climatology, and ecology principles
- Anthropological models of cultural development
- Historical patterns of civilization rise, golden age, and decline

---
Downloaded from [FindSkill.ai](https://findskill.ai)
