---
name: anxiety-thought-challenger
version: 1.0.0
---

# Anxiety Thought Challenger - Initialization

Identify and challenge anxious thinking patterns using CBT-based thought records. This skill guides users through recognizing cognitive distortions, examining evidence for and against anxious thoughts, building balanced perspectives, and developing long-term anxiety management habits.

**DISCLAIMER:** This is an educational self-help tool, NOT therapy. It does not replace professional mental health care.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with CBT thought record framework, cognitive distortion guide, grounding techniques, and progress tracking

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## What This Skill Does

1. **Identifies Cognitive Distortions**
   - 12 core distortion types with definitions and examples
   - Anxiety-specific manifestations for each
   - Challenging questions tailored to each distortion

2. **Guides Through Thought Records**
   - 7-step structured process (situation → thought → emotion → distortion → evidence → balanced thought → response)
   - Belief and emotion intensity rating scales
   - Socratic questioning to generate counter-evidence

3. **Provides Grounding Techniques**
   - 5-4-3-2-1 sensory grounding
   - Box breathing
   - Body scan
   - STOP technique
   - Temperature-based grounding

4. **Designs Behavioral Experiments**
   - Test anxious predictions in the real world
   - Compare expected vs. actual outcomes
   - Build evidence base against catastrophic thinking

5. **Implements Worry Time Scheduling**
   - Structured daily worry containment
   - Worry list and triage process
   - Actionable vs. non-actionable worry sorting

6. **Tracks Progress Over Time**
   - Weekly thought pattern reviews
   - Monthly pattern summaries
   - Anxiety trend monitoring

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r anxiety-thought-challenger/ ~/.claude/skills/anxiety-thought-challenger/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{distortion_focus}}` | `all` | Specific cognitive distortion to focus on |
| `{{anxiety_domain}}` | `general` | Life area (work, social, health, relationship, financial) |
| `{{thought_record_format}}` | `standard` | Record detail level (quick, standard, detailed) |
| `{{grounding_preference}}` | `sensory` | Grounding style (sensory, breathing, body-scan, temperature) |
| `{{session_goal}}` | `challenge_thought` | Session focus (challenge_thought, learn_distortions, grounding, review_patterns, worry_time_setup) |

## Safety Notes

**IMPORTANT**: This is an educational self-help tool, NOT therapy or clinical treatment.

- Always includes disclaimer that this does not replace professional mental health care
- Encourages seeking professional help for severe or persistent anxiety
- Crisis resources included: 988 Suicide & Crisis Lifeline, Crisis Text Line, IASP
- Does not diagnose, treat, or provide clinical advice
- Designed as complement to professional care, not replacement

## Example Usage

**Challenge a Specific Thought:**
"I keep thinking I'm going to get fired even though my performance reviews are fine. Every small mistake at work sends me into a spiral. Help me work through this thought pattern."

**Learn About Distortions:**
"I want to understand cognitive distortions better. Can you teach me the main types and help me figure out which ones I fall into most?"

**Acute Anxiety Grounding:**
"I'm feeling really anxious right now and I can't focus. Can you walk me through a grounding exercise?"

**Pattern Review:**
"I've been doing thought records for a few weeks. Can you help me look at my patterns and figure out what's working?"

**Worry Time Setup:**
"I worry about everything all day long. Help me set up a worry time schedule so I'm not constantly anxious."

## Research Basis

Built on evidence-based CBT concepts:
- Beck Institute cognitive model and thought record methodology
- David Burns' cognitive distortion taxonomy (Feeling Good)
- APA Clinical Practice Guidelines for anxiety disorders
- Cochrane systematic reviews confirming CBT efficacy for GAD
- SAMHSA evidence-based grounding techniques

---
Downloaded from [Find Skill.ai](https://findskill.ai)
