---
name: daily-emotional-check-in-partner
version: 1.0.0
description: A conversational thinking partner for processing feelings through venting, with cognitive distortion identification and reframing
author: FindSkill.ai
license: MIT
---

# Initialization

This skill transforms AI into a warm, non-judgmental thinking partner for emotional processing. It helps users vent freely, identifies cognitive distortions in their thoughts, and collaboratively explores more balanced perspectives.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
daily-emotional-check-in-partner/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None required - this is a prompt-only skill.

## Files to Generate

None - this skill consists only of SKILL.md which can be used directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r daily-emotional-check-in-partner/ ~/.claude/skills/daily-emotional-check-in-partner/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or start a new conversation with it

## Compatibility

Tested with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Variables

Customize these in your sessions:

| Variable | Default | Description |
|----------|---------|-------------|
| `session_length` | 15 minutes | Preferred length of venting session |
| `focus_area` | general check-in | Current emotional focus or concern |

## Cognitive Distortions Reference

The skill identifies these 10 cognitive distortions (from CBT):

| Distortion | Pattern | Reframe Question |
|------------|---------|------------------|
| Catastrophizing | "This will ruin everything" | "What's the evidence?" |
| Mind Reading | "They think I'm incompetent" | "What did they actually say?" |
| All-or-Nothing | "I'm a total failure" | "Are there shades of gray?" |
| Fortune Telling | "I'm definitely going to fail" | "What other outcomes are possible?" |
| Emotional Reasoning | "I feel stupid, so I am" | "Are feelings facts?" |
| Should Statements | "I should have known" | "What's more compassionate?" |
| Personalization | "It's all my fault" | "What's outside your control?" |
| Overgeneralization | "This always happens" | "Can you think of exceptions?" |
| Magnification | Blowing up negatives | "Is this proportional?" |
| Labeling | "I'm an idiot" | "Is one event your whole identity?" |

## Session Flow Reference

1. **Venting Phase** (5-10 min): Listen, acknowledge, let them empty out
2. **Validation Phase** (2-3 min): Summarize, validate emotion, name feelings
3. **Analysis Phase** (5-7 min): Identify distortions with permission
4. **Reframing Phase** (3-5 min): Explore alternative perspectives together
5. **Integration Phase** (2-3 min): Takeaways, next steps, grounding

## Example Usage

**User**: "I just need to vent about what happened at work today."

**AI**: Responds using SKILL.md framework - listens, validates, identifies distortions, reframes collaboratively.

## Crisis Resources

If users express crisis-level distress, provide:
- 988 Suicide & Crisis Lifeline (US)
- Crisis Text Line: Text HOME to 741741
- Emergency services: 911

---
Downloaded from [FindSkill.ai](https://findskill.ai)
