---
name: desk-ergonomics-auditor
version: 1.0.0
---

# Desk Ergonomics Auditor - Initialization

Comprehensive workstation assessment skill that evaluates computer workstations and provides specific, prioritized recommendations for posture, comfort, and injury prevention. Covers chair, desk, monitor, keyboard, mouse, lighting, standing desks, laptop ergonomics, multi-monitor setups, budget fixes, movement breaks, and body-type adaptations. Based on OSHA, NIOSH, and Cornell University ergonomic research.

**DISCLAIMER:** This is an educational tool, NOT medical advice. It does not replace a Certified Professional Ergonomist, physical therapist, or physician.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete workstation assessment framework, diagnostic guides, and audit report template

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## What This Skill Does

1. **Complete Workstation Assessment**
   - Chair: seat height, depth, lumbar support, backrest angle, armrests, padding
   - Desk: height, depth, under-desk clearance
   - Monitor: distance, height, tilt, brightness, color temperature
   - Keyboard: position, tilt (negative tilt critical), wrist rest usage
   - Mouse: position, size/grip, sensitivity, ergonomic alternatives
   - Lighting: ambient, glare control, task lighting, 20-20-20 rule

2. **Ideal Positioning Quick Reference**
   - Head and neck angles (10-20 degrees below horizontal)
   - Shoulder and arm positioning (elbows 90-110 degrees)
   - Wrist neutrality (no extension, flexion, or deviation)
   - Back and torso support (100-110 degree recline)
   - Hip and leg angles (thighs parallel, feet flat)

3. **Common Problem Diagnosis and Fixes**
   - Neck pain: monitor height, distance, phone cradling, document placement
   - Lower back pain: lumbar support, static posture, chair height, backrest angle
   - Wrist and hand pain: keyboard tilt, wrist resting, mouse reach, ulnar deviation
   - Eye strain: blink rate, brightness, glare, distance, text size
   - Shoulder and upper back pain: desk height, mouse position, armrest support

4. **Standing Desk Setup**
   - Proper standing desk height (elbows 90-100 degrees)
   - Monitor height when standing
   - Anti-fatigue mat and footrest requirements
   - Sit-stand transition protocol (beginner through ongoing)
   - Common standing mistakes (locked knees, hip leaning, no monitor adjustment)

5. **Laptop-Specific Ergonomics**
   - The fundamental laptop problem (coupled screen and keyboard)
   - Solution hierarchy: external monitor + keyboard down to laptop-only damage mitigation
   - Cost tiers from $0 to full setup

6. **Budget-Friendly Solutions**
   - $0 fixes (10 immediate adjustments)
   - Under $25 fixes (footrest, document holder, wrist pad)
   - Under $50 fixes (lumbar pillow, monitor stand, external keyboard, laptop stand)
   - Under $100 fixes (monitor arm, keyboard tray, ergonomic keyboard)
   - Premium investments (ergonomic chair, sit-stand desk, ultra-wide monitor)

7. **Movement Breaks and Micro-Exercises**
   - 20-30 minute micro-breaks (30-60 seconds)
   - 45-60 minute short breaks (2-5 minutes)
   - 2-hour active breaks (5-10 minutes)
   - 6 desk-friendly exercises: chin tucks, scapular squeezes, doorway pec stretch, seated figure-4, wrist stretches, standing hip flexor stretch
   - Automatic reminder tools (apps, browser extensions, smartwatch)

8. **Home Office vs. Corporate Office**
   - Home: kitchen chair problems, poor lighting, couch working, no dedicated space
   - Corporate: hot-desking adjustment, non-adjustable furniture, cubicle lighting, accommodations
   - 30-second hot-desk setup checklist

9. **Multi-Monitor Setup**
   - Dual monitors: equal use vs. primary/secondary positioning
   - Triple monitor arc layout
   - Universal rules: same height, arc layout, same brightness, taskbar placement

10. **Body Type Adaptations**
    - Petite users (<5'3"): footrest, smaller mouse, seat depth adjustment
    - Tall users (>6'2"): desk risers, extended-height chair, high monitor arm
    - Larger body types: wider chairs, high-density cushion, weight-rated chairs
    - Special conditions: scoliosis, pregnancy, post-surgery

11. **Audit Report Template**
    - Current setup summary with overall ergonomic score
    - Findings prioritized by impact (critical, important, recommended)
    - Shopping list with costs and sources
    - Movement plan tailored to user's complaints
    - 30-day check-in questions

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r desk-ergonomics-auditor/ ~/.claude/skills/desk-ergonomics-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{workspace_type}}` | `home office` | Type of workspace (home-office, corporate-office, hybrid, coworking-space, dorm-room) |
| `{{primary_complaint}}` | `general assessment` | Main discomfort (neck-pain, lower-back-pain, wrist-pain, eye-strain, shoulder-pain, headaches, numbness-tingling) |
| `{{budget}}` | `under $100` | Budget for improvements ($0-free-only, under-$50, under-$100, under-$250, under-$500, no-limit) |
| `{{hours_per_day}}` | `8` | Daily desk time (4, 6, 8, 10, 12+) |
| `{{equipment_type}}` | `laptop with external monitor` | Computer setup (desktop, laptop-only, laptop-with-monitor, dual-monitors, triple-monitors) |

## Safety Notes

**IMPORTANT**: This is an educational tool, NOT medical advice or treatment.

- Always includes disclaimer that this does not replace professional ergonomic assessment or medical care
- Encourages seeking professional help for persistent pain, numbness/tingling, or diagnosed conditions
- Does not diagnose, treat, or provide clinical advice
- Warning signs requiring professional evaluation are explicitly listed (carpal tunnel symptoms, weakness, night pain)
- Designed as complement to professional care, not replacement
- Recommendations based on published research from OSHA, NIOSH, Cornell, and peer-reviewed journals

## Example Usage

**Full Workstation Audit:**
"I work from home 9 hours a day at an IKEA desk with a 27-inch monitor and a basic office chair. My neck hurts by noon and my wrist is tingling. Can you audit my setup?"

**Specific Problem Fix:**
"My lower back is killing me after 4 hours of sitting. What's wrong with my chair setup?"

**Budget Upgrade Plan:**
"I have $75 to improve my home office ergonomics. What should I buy first?"

**Standing Desk Setup:**
"I just got a sit-stand desk. How do I set it up correctly and how often should I stand?"

**Laptop Ergonomics:**
"I work on a MacBook Pro 8 hours a day with no external peripherals. My neck and shoulders are wrecked. Help."

**Multi-Monitor Setup:**
"I have three monitors and my neck rotates all day. How should I position them?"

## Research Basis

Built on evidence-based ergonomic guidelines and research:
- OSHA Computer Workstations eTool
- Cornell University Human Factors and Ergonomics Research Group
- UCLA Ergonomics Guidelines
- NIOSH Publication No. 97-141 on musculoskeletal disorders and workplace factors
- Bashir et al. (2006) — lumbar disc pressure and seating angle research
- Hansraj (2014) — forward head posture and cervical spine load
- American Optometric Association — Computer Vision Syndrome research
- Applied Ergonomics systematic review on multi-component ergonomic interventions (2018)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
