---
name: no-jump-apartment-workout
version: 1.0.0
---

# No-Jump Apartment Workout - Initialization

A comprehensive fitness skill for apartment dwellers who need effective workouts without disturbing downstairs neighbors. Creates quiet, low-impact exercise programs using bodyweight progressions, isometric holds, and controlled movements.

## Structure

```
no-jump-apartment-workout/
├── SKILL.md      # Main skill prompt (copy to your AI assistant)
└── INIT.md       # This file - setup instructions
```

## Files to Generate

None - this is a prompt-only skill with no code dependencies.

## Post-Init Steps

### For Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r no-jump-apartment-workout/ ~/.claude/skills/no-jump-apartment-workout/
```

### For ChatGPT, Gemini, Copilot, or Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Start a conversation about your workout needs

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{workout_duration}}` | `45 minutes` | Total session time (30-60 min range) |
| `{{intensity_level}}` | `intermediate` | Difficulty: beginner, intermediate, advanced |
| `{{equipment_available}}` | `none` | Resources: none, bands, light_dumbbells, mat |
| `{{training_frequency}}` | `3` | Days per week (2-4 recommended) |
| `{{target_focus}}` | `full_body` | Goal: full_body, upper_body, lower_body, core, cardio |
| `{{rest_day_interval}}` | `1` | Minimum days between workouts |

## Quick Start Example

After setup, try this prompt:

```
I live on the third floor and my downstairs neighbors work nights.
Create a 45-minute full-body strength workout that's completely silent.
I have no equipment except a yoga mat, and I want to focus on building
muscle with progressive overload.
```

## Key Features

- **100+ exercise variations** organized by difficulty level
- **5 complete workout templates** from 35-50 minutes
- **Noise ratings** for every exercise (Silent to Very Low)
- **Progressive overload strategies** without jumping or equipment
- **Form cues and common mistakes** for injury prevention
- **Weekly programming structures** (3-day and 4-day splits)
- **Modifications** for beginners, joint issues, and advanced users

## Exercise Categories Included

- Push-Up Progressions (7 levels)
- Pull/Row Progressions (4 levels + band variations)
- Squat Progressions (6 levels)
- Lunge Variations
- Core work (anti-extension, anti-rotation, anti-lateral flexion)
- Isometric exercises (maximum quiet)
- Low-impact cardio (shadowboxing, marching, step touch)

## Target Users

- Apartment residents on upper floors
- Early morning or late night exercisers
- Space-constrained individuals (6ft x 4ft minimum)
- Low-impact exercise seekers
- Budget-conscious fitness enthusiasts

---
Downloaded from [Find Skill.ai](https://findskill.ai)
