---
name: stress-to-health-mapper
version: 1.0.0
---

# Initialization

The Stress-to-Health Mapper is an AI-powered assessment and intervention skill that helps users understand the bidirectional relationship between specific psychosocial stressors (occupational, financial, relational) and physical health manifestations. It bridges the critical gap between mind and body by making visible how stress triggers physical symptoms through well-documented biological pathways.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for stress-symptom mapping, validated assessments (PSS-10, SSS-8), psychosomatic pathway explanations, and evidence-based interventions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r stress-to-health-mapper/ ~/.claude/skills/stress-to-health-mapper/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Target Audience

- Corporate wellness professionals designing employee mental health programs
- Healthcare providers diagnosing/treating psychosomatic complaints
- Individuals in high-stress situations (job seekers, entrepreneurs, demanding roles)
- People with chronic unexplained symptoms (recurring headaches, digestive issues, fatigue)
- Therapists and counselors using as diagnostic/assessment tool
- Self-aware individuals seeking to optimize health through stress management

## Core Capabilities

1. **Stressor Assessment** - Comprehensive evaluation of occupational, financial, relational stressors with severity ratings
2. **Symptom Mapping** - Link physical manifestations (GI, cardiovascular, musculoskeletal, neurological) to specific stressors
3. **Psychosomatic Pathway Explanation** - Educate on HPA axis, cortisol, autonomic nervous system mechanisms
4. **Pattern Recognition** - Detect temporal relationships between stressors and symptom flares
5. **Personalized Intervention Design** - Generate targeted strategies matched to stressor profile
6. **Progress Tracking** - Monitor changes in stress/symptom burden; evaluate intervention effectiveness
7. **Professional Referral Guidance** - Recommend specialists when self-management insufficient

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{stressor_weight_occupational}}` | `1.0` | Occupational stress impact multiplier |
| `{{stressor_weight_financial}}` | `1.0` | Financial stress impact multiplier |
| `{{stressor_weight_relational}}` | `1.0` | Relationship stress multiplier |
| `{{intervention_frequency_daily_minutes}}` | `10` | Daily stress-management duration |
| `{{symptom_tracking_intensity}}` | `weekly` | Tracking frequency: daily, weekly, biweekly |
| `{{urgency_threshold_referral_days}}` | `14` | Days until professional referral recommendation |
| `{{somatic_symptom_severity_cutoff}}` | `8` | SSS-8 score threshold for specialist consultation |
| `{{intervention_preference_type}}` | `mixed` | Modality: cognitive, somatic, environmental, mixed |

## Research Foundation

This skill is based on validated clinical tools and peer-reviewed research:
- Perceived Stress Scale (PSS-10) - Gold standard for stress measurement
- Somatic Symptom Scale-8 (SSS-8) - Clinical symptom burden assessment
- HPA axis and psychoneuroimmunology research
- MBSR and CBT efficacy studies for stress-related symptoms
- Gut-brain axis research for GI manifestations

## Quick Start

After installing, start a conversation with:

> "I've been experiencing [symptom] and I think it might be related to stress from [stressor]. Can you help me understand the connection and what I can do about it?"

Example prompts:
- "I've been job searching for 3 months and my back pain has gotten worse. How is the stress affecting my body?"
- "My business is struggling financially and I have chronic digestive issues. What's the connection?"
- "Work deadlines give me tension headaches. Can you map what's happening and suggest interventions?"

---
Downloaded from [Find Skill.ai](https://findskill.ai)
