---
name: symptom-checker-journal
version: 1.0.0
description: Structured symptom tracking, pattern analysis, and doctor appointment preparation
author: FindSkill.ai
license: MIT
---

# Symptom Checker Journal — Initialization

## Overview

This is a prompt-only skill for structured health symptom tracking and pattern analysis. It provides daily symptom logs, lifestyle factor tracking, symptom-specific trackers, pattern analysis templates, and doctor appointment summaries.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with tracking templates and analysis guides
- `INIT.md` — This initialization guide

## Directory Structure

```
symptom-checker-journal/
├── SKILL.md    # Main skill with tracking frameworks
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Describe your symptoms and tracking goals

### ChatGPT / Gemini / Copilot
Same process — paste and describe what you want to track.

## Core Capabilities

1. **Daily Symptom Tracker** — Structured log with severity scale, context, and relief notes
2. **Lifestyle Factor Logging** — Sleep, food, medications, exercise, stress, and environment
3. **Symptom-Specific Trackers** — Custom templates for headaches, digestive issues, pain, sleep/fatigue, and mood
4. **Pattern Analysis** — Correlation tables and analysis templates after 1-2 weeks of data
5. **Doctor Appointment Summary** — One-page formatted summary with symptoms, patterns, medications, and questions
6. **Tracking Frequency Guide** — When to track daily, weekly, or as-needed

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `symptoms` | `` | The symptoms you want to track |
| `tracking_goal` | `understand my symptoms better` | Why you're tracking |
| `duration` | `` | How long you've been experiencing symptoms |

## Usage Examples

### Example 1: Pre-Appointment Tracking

**User:** "I've been having recurring headaches for 3 months and my doctor asked me to keep a diary before my next appointment."

**AI Response:** Creates a headache-specific tracker with timing, location, severity, potential triggers (screen time, meals, sleep, stress), relief methods, and a lifestyle factor log. After 2 weeks, generates a one-page appointment summary.

### Example 2: Food Trigger Investigation

**User:** "I think certain foods are causing my bloating and stomach pain but I can't figure out which ones."

**AI Response:** Sets up a digestive symptom tracker paired with a detailed food log. Includes suspected trigger food checklist (dairy, gluten, fried foods, etc.) and a correlation table to identify patterns after tracking.

### Example 3: Medication Monitoring

**User:** "I started a new anxiety medication and my doctor wants me to track how it's affecting me."

**AI Response:** Creates a mood/mental health tracker with daily anxiety levels, energy, emotions, side effects log, and medication timing. Includes weekly summary format for reporting to the prescribing doctor.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Tracking feels overwhelming | Start with just symptom + severity — add lifestyle factors after a few days |
| Forgetting to log | Set a daily phone alarm; log at the same time each day |
| Too many symptoms to track | Focus on the top 2-3 that bother you most |
| Can't spot patterns | Need at least 2 weeks of data; try the correlation table |
| Doctor doesn't look at diary | Use the one-page summary format — doctors prefer brief, structured data |

## Best Practices

1. **Keep it simple** — 5 minutes per day max; if it's a burden, you'll stop doing it
2. **Be specific** — "Sharp pain behind left eye, 7/10" beats "bad headache"
3. **Track timing** — When symptoms start AND end, not just that they happened
4. **Note context** — What you were doing, eating, or feeling when symptoms appeared
5. **Review weekly** — Look for patterns every Sunday rather than just logging blindly
6. **Bring a summary** — Doctors prefer a one-page summary over a stack of diary pages

---
Downloaded from [Find Skill.ai](https://findskill.ai)
