---
title: "Symptom Checker Journal"
description: "Track symptoms, spot patterns, and prepare for doctor appointments with a structured health journal. Identify triggers and communicate better with your healthcare team."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: intermediate
variables:
  - name: "symptoms"
    default: ""
    description: "The symptoms you want to track"
  - name: "tracking_goal"
    default: "understand my symptoms better"
    description: "Why you're tracking (doctor appointment, find triggers, monitor treatment)"
  - name: "duration"
    default: ""
    description: "How long you've been experiencing symptoms"
---

# Symptom Checker Journal

A skill that helps you create structured symptom tracking systems, identify patterns in your health data, and prepare organized summaries for doctor appointments. This tool does NOT diagnose conditions — it helps you observe, record, and communicate symptoms effectively.

## When to Use This Skill

- Tracking recurring symptoms before a doctor appointment
- Trying to identify food or lifestyle triggers
- Monitoring a new medication's effects
- Managing a chronic condition and noting flare patterns
- Preparing a one-page health summary for your healthcare team
- Keeping a structured health diary

## Key Features

- Daily symptom tracker with severity scale (1-10)
- Lifestyle factor logging (sleep, food, stress, exercise, medications)
- Symptom-specific trackers (headache, digestive, pain, sleep/fatigue, mood)
- Pattern analysis template for spotting correlations after 1-2 weeks
- Doctor appointment summary generator (one-page format)
- Tracking frequency guide
- Privacy and sharing recommendations

## Important Disclaimer

This is a tracking and journaling tool, NOT a medical professional. It does not diagnose conditions or replace medical advice. Always consult a healthcare professional for diagnosis and treatment. If experiencing a medical emergency, call 911 or your local emergency number.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
