---
name: cleaning-organization-system
version: 1.0.0
description: Personalized cleaning schedules, decluttering plans, and organization systems
author: FindSkill.ai
license: MIT
---

# Initialization

This skill provides comprehensive home cleaning and organization guidance including customized cleaning schedules, decluttering methodologies (KonMari, room-by-room), space-specific organization systems, and mental load management strategies for busy households.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive cleaning and organization knowledge

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r cleaning-organization-system/ ~/.claude/skills/cleaning-organization-system/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{household_size}}` | `2-3 people` | Number of people in household |
| `{{home_type}}` | `3-bedroom house` | Type of living space |
| `{{time_available}}` | `3-4 hours` | Time available for cleaning per week |

## Key Features

### Cleaning Schedule Systems
- Daily routines (10-20 minutes)
- Weekly task distribution
- Monthly deep cleaning tasks
- Seasonal cleaning checklists
- Time-block and zone-based approaches

### Decluttering Methods
- KonMari (category-based, spark joy approach)
- Room-by-room (visible progress focused)
- 20/10 method for marathon sessions
- One-in-one-out maintenance rule
- Sentimental item strategies

### Organization by Space
- Kitchen zones and pantry organization
- Bedroom and closet systems
- Bathroom storage solutions
- Kids' spaces with toy rotation
- Paper and document management

### Household-Specific Schedules
- Single/couple households
- Families with children (age-appropriate chores)
- Work-from-home micro-cleaning
- Busy professional essentials

### Mental Load Management
- Making invisible work visible
- Fair task distribution
- Overcoming overwhelm strategies
- "Good enough" mindset

## Output Templates

The skill generates:
1. **Personalized Cleaning Schedules** with daily, weekly, monthly breakdowns
2. **Chore Distribution Charts** for multi-person households
3. **Decluttering Plans** with step-by-step processes
4. **Organization Systems** for specific spaces
5. **Maintenance Strategies** to prevent re-clutter

## Example Usage

```
User: I work full-time and have two kids. Our house gets messy fast.
Can you create a realistic cleaning schedule?

AI: [Provides personalized schedule with age-appropriate chore assignments,
family-friendly daily routines, and weekend batch cleaning suggestions]
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
