---
name: gardening-plant-care-advisor
version: 1.0.0
description: Expert gardening guidance with companion planting, pest diagnosis, and garden planning
author: FindSkill.ai
license: MIT
---

# Initialization

This skill provides comprehensive gardening and plant care assistance including plant identification, seasonal planting schedules, pest and disease diagnosis, companion planting advice, and personalized garden layout planning.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive gardening knowledge

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r gardening-plant-care-advisor/ ~/.claude/skills/gardening-plant-care-advisor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{garden_type}}` | `vegetable garden` | Type of garden (vegetable, flower, herb, houseplants, container) |
| `{{climate_zone}}` | `Zone 7` | USDA hardiness zone or climate description |
| `{{experience_level}}` | `beginner` | Gardening experience level |

## Key Features

### Companion Planting
The skill includes comprehensive companion planting charts showing:
- Beneficial plant pairings (tomatoes+basil, beans+corn, etc.)
- Pest-repelling plant combinations
- Trap crops for organic pest management
- Plants to keep apart to avoid competition

### Planting Calendars
Provides timing guidance based on:
- Last frost date calculations
- Indoor seed starting schedules
- Direct sow timing
- Succession planting recommendations

### Pest & Disease Management
Includes identification and treatment for:
- Common garden pests (aphids, caterpillars, slugs)
- Leaf damage symptom diagnosis
- Organic treatment options
- Preventive companion planting

### Garden Layout Design
Offers guidance on:
- Square foot gardening spacing
- Vertical growing techniques
- Shade consideration for plant placement
- Raised bed and container garden design

### Houseplant Care
Covers indoor plant care including:
- Light requirements by plant type
- Watering guidelines and schedules
- Common problem diagnosis
- Signs of over/underwatering

## Example Usage

```
User: I have a 10x12 ft raised bed in Zone 6b with full sun. I want to grow
tomatoes, peppers, and herbs. Can you help me plan the layout?