---
name: price-comparison-helper
version: 1.0.0
description: Compare prices and find the real best deal on any product or service
author: FindSkill.ai
license: MIT
---

# Price Comparison Helper — Initialization

## Overview

This is a prompt-only skill for comparing prices across products, stores, and services. It goes beyond sticker price to calculate unit costs, total cost of ownership, cost-per-use, and hidden fees.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with 5 comparison methods and decision frameworks
- `INIT.md` — This initialization guide

## Directory Structure

```
price-comparison-helper/
├── SKILL.md    # Main skill with comparison methods and templates
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Tell Claude what you're comparing and what matters most to you

### ChatGPT / Gemini / Copilot
Same process — paste and describe the products or services you're comparing.

## Core Capabilities

1. **Unit Price Comparison** — Compare different sizes and quantities
2. **Total Cost of Ownership** — Factor in energy, maintenance, and resale value
3. **Cost Per Use** — Calculate real value based on usage frequency
4. **Subscription Comparison** — Evaluate recurring costs and feature value
5. **Store Comparison** — Compare same product across retailers (tax, shipping included)
6. **Decision Matrix** — Weighted scoring for complex multi-factor decisions
7. **Deal Evaluation** — Determine if a sale is actually worth it
8. **Hidden Cost Detection** — Checklist of frequently overlooked expenses

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `product` | `` | The product or service to compare |
| `options` | `` | The options to choose between |
| `priority` | `best value` | What matters most (lowest price, best value, quality) |

## Usage Examples

### Example 1: Appliance Purchase

**User:** "Comparing three washing machines at different price points with different energy ratings."

**AI Response:** Creates a 5-year Total Cost of Ownership table including purchase price, annual energy costs, repair estimates, warranty coverage, and resale value.

### Example 2: Grocery Shopping

**User:** "Which olive oil is the best deal — the 16 oz for $6.99 or the 32 oz for $7.99?"

**AI Response:** Calculates unit price per ounce, recommends the better value, and notes expiration considerations.

### Example 3: Subscription Evaluation

**User:** "Should I get Spotify, Apple Music, or YouTube Music?"

**AI Response:** Compares monthly vs. annual pricing, features per dollar, free tier availability, and family plan options.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Not sure what to compare | Start with the 2-3 options you're considering |
| Too many factors | Use the decision matrix with weighted scoring |
| Can't find prices | Use price tracking tools (CamelCamelCamel, Google Shopping) |
| Sale seems too good | Run it through the "Is It Really a Deal?" framework |
| Big purchase anxiety | Apply the "$100 Rule" — wait proportionally to price |

## Best Practices

1. **Always include hidden costs** — shipping, tax, accessories, installation
2. **Compare apples to apples** — same size, features, and warranty terms
3. **Consider the time cost** — driving to 3 stores for $5 savings may not be worth it
4. **Check price history** — current "sale" price might be the normal price
5. **Factor in your usage** — cost per use matters more than sticker price
6. **Sleep on big purchases** — impulse rarely leads to the best deal

---
Downloaded from [Find Skill.ai](https://findskill.ai)
