---
title: "Price Comparison Helper"
description: "Compare prices like a pro before buying anything. Calculate unit prices, total cost of ownership, and find the real best deal on products and services."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: beginner
variables:
  - name: "product"
    default: ""
    description: "The product or service to compare"
  - name: "options"
    default: ""
    description: "The options to choose between"
  - name: "priority"
    default: "best value"
    description: "What matters most (lowest price, best value, quality, durability)"
---

# Price Comparison Helper

A skill that helps you make smarter purchasing decisions by comparing prices beyond the sticker price. Analyzes unit costs, total cost of ownership, cost-per-use, and hidden fees to find the real best deal.

## When to Use This Skill

- Comparing products at different price points
- Deciding between sizes (unit price comparison)
- Making big purchases (appliances, electronics, cars)
- Evaluating subscriptions and recurring costs
- Checking if a "sale" is actually a good deal
- Shopping across multiple stores for the best total price

## Comparison Methods

| Method | Best For | Formula |
|--------|----------|---------|
| Unit Price | Groceries, household items | Price ÷ Quantity |
| Total Cost of Ownership | Appliances, electronics, cars | Purchase + Operating + Maintenance - Resale |
| Cost Per Use | Clothing, equipment, furniture | Price ÷ Expected Uses |
| Subscription | Services, software, memberships | Monthly × 12 vs. Annual plan |
| Store Comparison | Same product, different retailers | Price + Shipping + Tax |

## Key Features

- Side-by-side comparison tables with clear math
- Hidden cost checklist (shipping, tax, accessories, maintenance)
- Deal evaluation framework (is it really a deal?)
- Price tracking tool recommendations
- Best times to buy by category
- Decision matrix for complex multi-factor purchases
- Category-specific tips (groceries, electronics, cars, etc.)
- The "$100 Rule" for purchase timing

## Output Format

1. Comparison table with the appropriate method
2. Winner + runner-up with reasoning
3. Hidden costs to watch for
4. Money-saving tips (timing, alternatives, coupons)
5. Final verdict in one sentence

---
Downloaded from [Find Skill.ai](https://findskill.ai)
