---
name: commute-cost-calculator
version: 1.0.0
---

# Initialization

A comprehensive financial calculator that reveals the true cost of commuting decisions. Helps users compare housing options by analyzing vehicle expenses, depreciation, time value, insurance, health impacts, and quality-of-life factors—going far beyond simple fuel calculations.

## Structure

- `SKILL.md` - Main skill prompt with complete calculation methodology

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r commute-cost-calculator/ ~/.claude/skills/commute-cost-calculator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{hourly_wage}}` | `30` | Gross hourly wage for time value calculations |
| `{{current_commute_minutes}}` | `15` | Current one-way commute time in minutes |
| `{{proposed_commute_minutes}}` | `45` | Proposed one-way commute time in minutes |
| `{{current_rent}}` | `1400` | Current monthly rent amount |
| `{{proposed_rent}}` | `1100` | Proposed monthly rent amount |
| `{{daily_round_trip_miles}}` | `40` | Total daily round-trip distance in miles |

## Key Features

### Cost Components Analyzed
- **IRS Mileage Rate** ($0.67/mile): Fuel, depreciation, maintenance, insurance, registration, financing
- **Time Value**: Three calculation methods (effective rate, salary equivalent, multiplier)
- **Hidden Costs**: Parking, tolls, insurance differentials, vehicle lifespan
- **Health Impact**: Stress and depression correlations for long commutes
- **Opportunity Costs**: Side income, skill development, caregiving time

### Output Includes
- Side-by-side cost comparison table
- Annual totals (not just monthly)
- Break-even analysis
- Time spent commuting calculation
- Clear recommendation with confidence level
- Marchetti threshold warnings (>60 min daily)

## Example Usage

```
I'm considering moving from my current apartment ($1,400/month, 15-minute
commute) to a cheaper place ($1,100/month, 45-minute commute). I make
$65,000/year and drive a 2019 Honda Civic. The new place is 25 miles from
work vs. my current 8 miles. Help me figure out if the $300 savings is
actually worth it when I factor in all the hidden commute costs.
```

## Research Sources

- IRS Standard Mileage Rates 2024-2025
- Marchetti Constant (commute duration research)
- Depression and commute correlation studies
- AAA Vehicle Operating Cost data
- Bureau of Labor Statistics Time Use Survey

---
Downloaded from [Find Skill.ai](https://findskill.ai)
