---
name: lease-gotcha-scanner
version: 1.0.0
---

# Lease Gotcha Scanner - Initialization

Detect hidden traps in rental lease agreements before you sign. This skill transforms your AI assistant into an expert lease analyst that flags illegal clauses, auto-renewal traps, excessive fees, and unfavorable terms with state-specific legal references.

## What This Skill Does

- **Scans lease documents** for 20+ categories of problematic clauses
- **Flags severity levels**: 🔴 Critical (illegal/unenforceable), 🟡 Concern (unfavorable), 🟢 Info (standard)
- **Detects auto-renewal traps** and calculates your notice deadline
- **Identifies financial gotchas**: excessive late fees, non-refundable deposits, hidden charges
- **Cross-references state law** to determine enforceability
- **Generates negotiation language** for landlord discussions
- **Extracts Schedule A addendums** that modify base lease protections

## Package Structure

```
lease-gotcha-scanner/
├── SKILL.md    # Main skill prompt (copy to your AI)
└── INIT.md     # This initialization file
```

## Files to Generate

None - this is a prompt-only skill. The AI uses its existing knowledge of tenant law combined with the structured analysis framework in SKILL.md.

## Installation

### Claude Code
```bash
cp -r lease-gotcha-scanner/ ~/.claude/skills/lease-gotcha-scanner/
```

Then reference in conversations: "Use my lease-gotcha-scanner skill to analyze this lease."

### ChatGPT / GPT-4
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a system prompt or at the start of your conversation
4. Upload or paste your lease document

### Claude.ai (Web)
1. Start a new conversation
2. Copy the full content of `SKILL.md` (excluding frontmatter)
3. Paste as your first message
4. Follow up with your lease document

### Gemini
1. Copy `SKILL.md` content
2. Paste into Gemini as context
3. Upload or paste lease for analysis

### Custom GPT
1. Create new GPT at chat.openai.com/gpts/editor
2. Paste `SKILL.md` content into Instructions
3. Name: "Lease Gotcha Scanner"
4. Description: "Analyze rental leases for hidden traps and unfavorable clauses"
5. Enable "Code Interpreter" for PDF analysis
6. Save and use

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{jurisdiction_code}}` | `US_NY` | Two-letter state/province code (e.g., US_CA, US_TX, CA_ON) for applicable tenant laws |
| `{{severity_threshold}}` | `yellow` | Minimum severity to display: red (critical only), yellow (critical + risky), green (all) |
| `{{include_schedule_a}}` | `true` | Whether to separately analyze Schedule A addendums and riders |
| `{{output_format}}` | `summary_first` | Report format: summary_first, detailed_only, or comparison_mode |
| `{{flag_categories}}` | `all` | Categories to flag: financial, renewal, occupancy, entry, repair, legal, or all |

## Quick Start Examples

### Full Lease Scan
```
I'm about to sign a 12-page lease for an apartment in Brooklyn, NY.
It includes a Schedule A addendum. Can you scan it for gotcha clauses?

[Paste or upload lease]
```

### Auto-Renewal Check
```
My lease ends June 30, 2025. It says "automatically renews for successive
12-month terms unless either party provides 60 days written notice."
What's my deadline to notify the landlord?
```

### Financial Analysis
```
My lease has:
- $1,800/month rent
- $1,800 security deposit
- $300 "non-refundable cleaning deposit"
- $75 late fee if rent is 1 day late

I'm in California. Which of these are legal?
```

### Schedule A Review
```
The main lease looks standard, but there's a Schedule A with 15 additional
clauses. Some seem to conflict with the main lease. Can you analyze what
the "effective" terms actually are?
```

## State-Specific Features

The skill includes quick-reference tables for:
- Late fee caps by state
- Security deposit limits
- Entry notice requirements
- Auto-renewal enforceability rules

Supported jurisdictions include all 50 US states and Canadian provinces, with detailed coverage for high-volume markets (CA, NY, TX, FL, IL, WA, OR, CO).

## Output Format

The skill generates:

1. **Executive Summary** (1 page)
   - Property details and lease term
   - Scan summary with flag counts
   - Top 3 priority issues
   - Financial snapshot
   - Renewal deadline alert

2. **Detailed Analysis** (per clause)
   - Original text quoted
   - Severity rating
   - Legal status and statute citation
   - Recommended action
   - Negotiation language

3. **Actionable Checklist**
   - Modifications to request
   - Calendar reminders to set
   - Documentation to prepare

## Best Use Cases

- **Before signing a new lease** - Identify issues to negotiate
- **At renewal time** - Check for auto-renewal traps and rent escalation
- **After receiving lease addendum** - Analyze Schedule A modifications
- **When landlord proposes changes** - Compare before/after versions
- **Moving to a new state** - Understand jurisdiction-specific protections

## Limitations

- **Not legal advice**: This skill provides educational analysis, not legal counsel
- **Laws change**: Verify current statutes with local tenant rights organizations
- **Local ordinances**: Some cities have additional protections beyond state law
- **Complex disputes**: Consult an attorney for significant legal issues

## Related Skills

- [Rent Increase Negotiation Scripts](/skills/housing/rent-increase-negotiation-scripts/) - Negotiate after identifying unfavorable escalation clauses
- [Roommate Agreement Drafter](/skills/housing/roommate-agreement-drafter/) - Create roommate contracts complementing your main lease
- [Move Out Fund Planner](/skills/housing/move-out-fund-planner/) - Calculate costs based on deposit and termination clauses
- [Late Fee Negotiator](/skills/money/late-fee-negotiator/) - Get excessive fees waived after identifying violations

---
Downloaded from [Find Skill.ai](https://findskill.ai)
