---
name: lease-renegotiation-strategist
version: 1.0.0
---

# Lease Renegotiation Strategist - Initialization

Expert lease negotiation consultant for renegotiating commercial and residential rental agreements. Provides strategic analysis, professional communication templates, and data-driven arguments to help tenants achieve better lease terms.

## What This Skill Does

- Analyzes your current lease situation and identifies leverage points
- Generates professional negotiation emails, letters, and phone scripts
- Calculates net effective rent to compare offers accurately
- Provides "Blend and Extend" strategy for commercial tenants paying above-market rates
- Helps residential tenants counter rent increase notices
- Explains complex lease terminology (CAM, TI, NNN, holdover, etc.)
- Creates Letters of Intent (LOI) for commercial negotiations
- Offers counter-offer strategies and objection handling techniques

## Structure

```
lease-renegotiation-strategist/
├── SKILL.md      # Main skill prompt (paste into AI assistant)
├── INIT.md       # This file - setup instructions
└── index.md      # Website listing metadata
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to Claude Code skills directory
cp -r lease-renegotiation-strategist/ ~/.claude/skills/lease-renegotiation-strategist/
```

Then reference in your prompts or add to project context.

### For ChatGPT, Gemini, Copilot, or Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into a new conversation as a system prompt or initial message
4. Begin asking about your lease situation

### Quick Start Conversation

After loading the skill, start with:

```
I need help renegotiating my lease. Here's my situation:
- Lease type: [residential/commercial]
- Current rent: $[amount]/month
- Lease expires: [date]
- Market seems to be [higher/lower/same]
- I've been a tenant for [X] years with [perfect/good] payment history
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{lease_type}}` | `residential` | Type: 'residential' or 'commercial' (changes strategy significantly) |
| `{{current_rent}}` | `2000` | Current monthly rent in dollars |
| `{{market_rate_delta}}` | `-10%` | Difference vs. market (negative = market is cheaper) |
| `{{leverage_points}}` | `perfect payment history, willing to sign 24 months` | Your negotiation assets |
| `{{desired_concessions}}` | `rent reduction, parking included` | What you want beyond rent reduction |
| `{{relationship_tone}}` | `professional` | Style: 'formal', 'friendly', or 'adversarial' |

## Example Prompts

**Residential Rent Increase Response:**
```
I just got a renewal notice raising my rent 12% from $1,800 to $2,016.
I checked the building website and identical units are listed at $1,750.
I've been here 3 years with zero late payments. Help me write an email
to the property manager asking them to match the new tenant rate.
```

**Commercial Blend and Extend:**
```
My business has 18 months left on a 5-year office lease at $42/SF.
Market rates have dropped to $35/SF. Draft a Letter of Intent proposing
we extend to a fresh 5-year term if they reset our rate to $37/SF now.
```

**Calculate Net Effective Rent:**
```
Compare these two offers:
- Offer A: $2,200/month for 12 months, no concessions
- Offer B: $2,400/month for 12 months with 1 month free

Which has the lower net effective rent?
```

**Handle Objection:**
```
The property manager said "our rates are set by the Yieldstar system
and there's nothing I can do." How should I respond?
```

## Key Capabilities

1. **Market Rate Analysis** - Compare terms against active listings
2. **Net Effective Rent Calculator** - True cost after concessions
3. **Communication Scripting** - Emails, letters, phone scripts
4. **Blend and Extend Deals** - Lower rent now for longer term
5. **Concession Trading** - Identify valuable trade-offs
6. **Counter-Offer Analysis** - Evaluate landlord proposals
7. **Objection Handling** - Responses for common pushback

## Important Notes

- Start early: Commercial 12-18 months out, Residential 60-90 days
- Always get everything in writing - verbal promises are unenforceable
- Calculate net effective rent when comparing any offers
- Landlords hate lowering "face rent" - ask for free months instead
- Know your BATNA (Best Alternative To Negotiated Agreement)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
