---
name: rent-increase-negotiation-scripts
version: 1.0.0
---

# Initialization

Expert rent negotiation coach that provides ready-to-use scripts, email templates, and phone talking points to help tenants respond to rent increases. Includes 7 battle-tested scripts, market research guidance, leverage assessment framework, and landlord objection rebuttals.

## Structure

- `SKILL.md` - Main skill prompt with all negotiation scripts and strategies

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r rent-increase-negotiation-scripts/ ~/.claude/skills/rent-increase-negotiation-scripts/
```

### ChatGPT / Gemini / Copilot
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Describe your rent increase situation and ask for help

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_rent}}` | `$1,800` | Your current monthly rent amount |
| `{{proposed_increase}}` | `$200` | The amount of the proposed rent increase |
| `{{years_as_tenant}}` | `2` | How many years you've lived in the unit |
| `{{market_rate}}` | `$1,850` | Average rent for comparable units in your area |
| `{{jurisdiction}}` | `United States` | Your state/city for tenant law specifics |
| `{{landlord_type}}` | `individual owner` | Type of landlord (individual, property management, corporate) |

## Example Usage

**Initial prompt:**
> "I just received a rent increase notice. My current rent is $1,800/month and they want to raise it to $2,100 (16.7% increase). I've lived here for 3 years with a perfect payment history. Comparable apartments in my Austin, TX neighborhood are renting for $1,850-$1,900. I want to negotiate this down or get concessions. Can you help me craft a counter-offer email and prepare talking points for a phone call?"

**What you'll get:**
- Leverage assessment (strong position based on tenure and market data)
- Customized opening email
- Data-driven counter-offer with market comparables
- Phone call talking points with objection handling
- Recommended counter-offer amount
- Alternative terms to propose if they won't budge on price
- Decision framework: accept, negotiate, or move

## Included Scripts

1. **Professional Opening Email** - First contact after receiving notice
2. **Data-Driven Counter Offer** - With market research and comparables
3. **Appeal to Financial Interest** - For individual landlords (not corporate)
4. **Alternative Terms Request** - Trade concessions for accepting increase
5. **Legal Concerns Letter** - For rent control violations
6. **Phone Call Talking Points** - Complete conversation guide with rebuttals
7. **Decline Letter** - Professional exit when negotiation fails

## Key Features

- **Leverage Assessment Framework**: Score your negotiating position (1-30 scale)
- **Market Research Guidance**: How to find and document comparable rents
- **Landlord Cost Calculator**: Help landlord see the cost of losing you
- **Objection Handling**: Pre-written rebuttals for common landlord responses
- **Decision Framework**: Math to determine if you should stay or move
- **Legal Context**: Rent control laws by state/city
- **Timing Guidelines**: When to negotiate based on lease timeline

## Success Rates

Industry data suggests:
- 30-40% of tenants who negotiate get some reduction
- Average reduction when successful: 5-15% off proposed increase
- Longer-tenured tenants (3+ years) have highest success rates

---
Downloaded from [Find Skill.ai](https://findskill.ai)
