---
name: compensation-benchmarking
version: 1.0.0
---

# Compensation Benchmarking - Initialization

Transform your AI assistant into an expert compensation analyst for market benchmarking, salary analysis, pay equity audits, and strategic HR compensation planning.

## What This Skill Does

This skill enables AI to help HR professionals and business leaders:
- Benchmark salaries against market data using percentile analysis
- Match internal jobs to external survey benchmarks accurately
- Conduct pay equity audits using regression methodology
- Design salary band structures with appropriate spreads
- Calculate compa-ratios and identify pay positioning issues
- Develop compensation communication strategies

## Package Structure

```
compensation-benchmarking/
├── SKILL.md    # Main skill prompt (copy to AI)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r compensation-benchmarking/ ~/.claude/skills/compensation-benchmarking/
```

Then reference in your prompts or add to project context.

### ChatGPT / Custom GPTs

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your Custom GPT's instructions or system prompt

### Claude.ai / Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste at the beginning of your conversation
4. Continue with your compensation benchmarking questions

## Variables

Customize these parameters for your organization:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_percentile}}` | `50` | Market percentile target (25=below-market, 50=median, 75=above-market) |
| `{{benchmarking_frequency}}` | `Annual` | How often to conduct full reviews (Quarterly, Semi-annual, Annual) |
| `{{data_source_count}}` | `2-3` | Number of external data sources to cross-validate |
| `{{job_match_threshold}}` | `80` | Minimum job match accuracy percentage required |
| `{{peer_group_size}}` | `10-15` | Number of comparable organizations in peer group |
| `{{include_total_rewards}}` | `Yes` | Analyze total compensation (base + bonus + equity + benefits) |

## Example Usage

After initializing the skill, try prompts like:

**Role Benchmarking:**
```
Benchmark our Software Engineer role (Senior level) in San Francisco
against current market data to determine if our $180k base salary
is competitive. Our target is the 50th percentile.
```

**Pay Equity Audit:**
```
Conduct a pay equity analysis on our 500-person marketing department
using regression to identify any gender pay gaps across all levels.
```

**Global Compensation:**
```
Create a global compensation framework for our 50-person fully remote
company spanning 12 countries. We want to maintain internal equity
while paying market rates locally.
```

**Salary Band Design:**
```
Design salary bands for our engineering organization with 5 levels
(Junior through Principal). Target 50th percentile with 35% band spreads.
```

## Key Capabilities

1. **Market Data Analysis** - Synthesize insights from Mercer, Payscale, Radford, government data
2. **Job Matching** - 80%+ accuracy by responsibilities, not just titles
3. **Percentile Positioning** - 25th/50th/75th percentile framework
4. **Pay Equity Audits** - Regression analysis for demographic gap detection
5. **Salary Band Design** - Ranges with min/mid/max and appropriate spreads
6. **Compa-Ratio Analysis** - Identify over/underpayment patterns
7. **Communication Strategy** - Transparent narratives for compensation changes

## Related Skills

- HR Analytics - Workforce data analysis
- Salary Inflation Adjuster - Cost-of-living adjustment calculations
- Job Offer Comparison Tool - Multi-offer analysis
- Employee Development Plan Generator - Career planning
- Financial Analytics - Financial modeling and metrics

## Troubleshooting

**Issue: No market data for specialized role**
Solution: Deconstruct role into component skills, interpolate from 2-3 adjacent benchmarks

**Issue: Wide variance across data sources**
Solution: Check geographic/industry cuts, calculate weighted average by sample confidence

**Issue: Systematic underpayment across organization**
Solution: Quantify total cost, propose phased implementation, prioritize by retention risk

## Resources Referenced

- Meridian Compensation Partners Best Practices Guide
- Mercer Salary Benchmarking Methodology
- Aon Compensation 101 - Market Benchmarking
- PayAnalytics Pay Equity Five-Step Process
- PerformYard Compensation Benchmarking Guide

---
Downloaded from [Find Skill.ai](https://findskill.ai)
