---
name: culture-fit-evaluator
version: 1.0.0
---

# Initialization

Culture Fit Evaluator - A structured assessment framework for evaluating candidate-organization cultural alignment through behavioral interviewing, values mapping, and psychometric insights. Helps HR professionals, hiring managers, and recruiters design objective, bias-aware hiring processes.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive behavioral interviewing framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r culture-fit-evaluator/ ~/.claude/skills/culture-fit-evaluator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Culture Fit Evaluator")
3. Paste into AI assistant as system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{organization_values}}` | `collaboration, innovation, accountability, customer-focus` | Core values your organization has explicitly defined (list 4-6) |
| `{{role_type}}` | `individual contributor` | Role level being hired: individual contributor, team lead, manager, executive |
| `{{culture_archetype}}` | `balanced` | Dominant culture type from Competing Values Framework: clan, adhocracy, market, hierarchy, or balanced |
| `{{assessment_depth}}` | `standard` | Assessment thoroughness: quick (15 min), standard (30-45 min), comprehensive (60+ min) |
| `{{industry_context}}` | `technology` | Industry sector for contextually relevant examples and considerations |

## Key Frameworks Included

### Competing Values Framework (OCAI)
- **Clan**: Family-like, collaborative, consensus-driven
- **Adhocracy**: Entrepreneurial, innovative, risk-taking
- **Market**: Results-oriented, competitive, goal-driven
- **Hierarchy**: Structured, process-driven, efficiency-focused

### Assessment Components
1. Behavioral interview questions (STAR-L format)
2. Scoring rubrics (1-5 scale with weighted dimensions)
3. Red flag identification guide
4. Culture add evaluation framework
5. Reference check protocols
6. Calibration meeting structure

### Question Categories
- Collaboration and Teamwork
- Feedback and Growth Mindset
- Adaptability and Change
- Values and Ethics
- Conflict and Difficult Situations
- Initiative and Ownership

## Example Usage

```
I'm hiring a senior product manager for our fintech startup. Our core values
are transparency, customer obsession, and move-fast-learn-faster. We have a
strong adhocracy culture with flat hierarchy. Generate a culture fit interview
guide with 8-10 behavioral questions, red flags to watch for, and a scoring
rubric I can use across all candidates.
```

## Outputs the Skill Generates

1. **Custom Interview Guides** - Role-specific behavioral questions aligned to your values
2. **Scoring Tools** - Candidate assessment scorecards and comparison matrices
3. **Process Design** - Multi-round interview structures and panel composition
4. **Analysis** - Candidate cultural profile synthesis and red flag interpretation
5. **Training Materials** - Interviewer calibration exercises and bias awareness guides

## Research Foundation

Based on peer-reviewed research and industry best practices including:
- Cameron and Quinn's Competing Values Framework
- Behavioral interviewing methodology (STAR-L)
- Organizational Culture Assessment Instrument (OCAI)
- Google's structured hiring practices
- Values-Based Recruitment frameworks

---
Downloaded from [Find Skill.ai](https://findskill.ai)
