---
name: data-breach-notification
version: 1.0.0
---

# Initialization

Create GDPR-compliant 72-hour breach notifications with templates for supervisory authorities and affected individuals.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r data-breach-notification/ ~/.claude/skills/data-breach-notification/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{organization_name}}` | `Your Organization` | Your organization's legal name |
| `{{breach_type}}` | `unauthorized access` | Type of breach (unauthorized access, data theft, ransomware, accidental disclosure) |
| `{{data_affected}}` | `names, emails, hashed passwords` | Categories of data compromised |
| `{{supervisory_authority}}` | `ICO (UK)` | Relevant data protection authority |

---
Downloaded from [Find Skill.ai](https://findskill.ai)