---
name: diversity-inclusion-audit
version: 1.0.0
---

# Diversity & Inclusion Audit - Initialization

A comprehensive HR analytics skill for systematically assessing workforce diversity, equity, and inclusion across hiring, promotion, retention, and compensation to identify disparities, uncover hidden biases, and provide data-driven recommendations.

## Structure

```
diversity-inclusion-audit/
├── SKILL.md    # Main skill prompt (comprehensive D&I audit system)
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

This skill is a comprehensive prompt that guides AI assistants through conducting D&I audits. No additional files, scripts, or configurations are required.

## Post-Init Steps

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r diversity-inclusion-audit/ ~/.claude/skills/diversity-inclusion-audit/
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of your conversation
4. Begin your D&I audit by providing organizational context and data

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{demographic_dimensions}}` | `gender, race/ethnicity, age, disability status` | Demographic categories to analyze in the audit |
| `{{promotion_look_back_years}}` | `3` | Number of years to analyze for promotion rate calculations |
| `{{tenure_control_threshold}}` | `2` | Years of tenure threshold for fair comparison in promotion analysis |
| `{{pay_equity_regression_factors}}` | `years_experience, education_level, performance_rating` | Legitimate business factors to control for in pay equity regression |
| `{{statistically_significant_threshold}}` | `0.05` | P-value threshold for determining statistical significance |
| `{{intersectionality_minimum_group_size}}` | `5` | Minimum employees in intersectional subgroup to report (privacy protection) |

## Core Capabilities

This skill provides 6 analysis modules:

1. **Demographic Representation Analysis** - Workforce composition mapping, diversity index, representation gaps
2. **Hiring Pipeline Bias Analysis** - Conversion rates, adverse impact ratios, source effectiveness
3. **Pay Equity Analysis** - Raw gaps, regression-controlled gaps, remediation costing
4. **Promotion Equity Assessment** - Promotion rates, time-to-promotion, leadership pipeline
5. **Retention & Turnover Analysis** - Demographic turnover rates, exit reasons, engagement correlation
6. **Intersectional Fairness Analysis** - Compounded discrimination at identity intersections

## Example Usage

```
Conduct a comprehensive D&I audit for our company. We have 2,500 employees across 8 departments.

Here's our demographic data summary:
- Gender: 62% male, 36% female, 2% non-binary
- Race/Ethnicity: 68% White, 12% Asian, 10% Hispanic/Latino, 7% Black, 3% other
- Age: 15% under 30, 55% 30-45, 25% 46-55, 5% over 55

Key areas of concern:
1. Women represent only 18% of engineering leadership (director+)
2. We've had 3 EEOC complaints in the past year
3. Exit interviews show underrepresented groups cite "lack of advancement" more often

Analyze our current state, identify key disparities, and provide specific recommendations.
```

## Key Metrics Covered

- **Diversity Index**: 1 - Σ(proportion of each group)²
- **Adverse Impact Ratio**: Selection rate of protected group ÷ Selection rate of majority group (80% rule)
- **Pay Gap (Raw)**: (Median Group A / Median Group B) - 1
- **Pay Gap (Adjusted)**: Residual after regression controlling for legitimate factors
- **Promotion Rate**: Promotions ÷ Eligible employees by demographic
- **Turnover Rate**: Departures ÷ Average headcount by demographic

## Regulatory Context

The skill incorporates awareness of:
- EEOC Title VII requirements
- OFCCP federal contractor obligations
- State-level pay transparency laws
- Adverse impact doctrine and 80% rule
- Documentation requirements for compliance

## Best For

- HR professionals conducting workforce assessments
- Diversity & Inclusion specialists building strategic initiatives
- Organizational leaders evaluating equity progress
- Legal/compliance teams managing discrimination risk
- Researchers analyzing workforce equity patterns

---
Downloaded from [Find Skill.ai](https://findskill.ai)
