---
name: employee-development-plan-generator
version: 1.0.0
---

# Employee Development Plan Generator - Initialization

Create personalized, milestone-driven employee development plans with SMART goals, competency gap analysis, and structured learning paths aligned with career aspirations and organizational strategy.

## What This Skill Does

This skill transforms your AI assistant into an expert HR strategist and talent development specialist capable of:

- **Personalized Plan Generation**: Create customized development plans matching employee role, aspirations, current skills, and organizational needs
- **Competency Gap Analysis**: Identify specific skill gaps between current and target proficiency levels using a 4-level framework
- **SMART Goal Creation**: Generate specific, measurable, achievable, relevant, time-bound objectives
- **Milestone Planning**: Structure development into 30-60-90 day phases or quarterly reviews
- **Resource Recommendation**: Suggest training, mentoring, projects, and learning activities using the 70-20-10 model
- **Progress Tracking Framework**: Establish metrics, KPIs, and assessment criteria for success

## Package Structure

```
employee-development-plan-generator/
├── SKILL.md          # Main skill prompt (copy into AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill. All functionality is contained within SKILL.md.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r employee-development-plan-generator/ ~/.claude/skills/employee-development-plan-generator/
```

Then reference in your project's CLAUDE.md:
```markdown
## Available Skills
- `employee-development-plan-generator` - Create employee development plans with SMART goals
```

### ChatGPT / Claude / Gemini / Other AI Assistants

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of your conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{employee_role}}` | `Software Engineer` | Current job title/role - determines relevant competencies |
| `{{career_aspiration}}` | `Senior Manager` | Target role (Manager/Technical Expert/Executive/Specialist) |
| `{{development_timeline}}` | `12 months` | Plan duration (90 days/6 months/1 year/2 years) |
| `{{primary_focus_area}}` | `Leadership Skills` | Main development concentration area |
| `{{learning_preference}}` | `Mixed` | Learning modalities (Formal/Hands-on/Mentoring/Self-paced/Mixed) |
| `{{milestone_frequency}}` | `Quarterly` | Review cadence (Monthly/Quarterly/Semi-annually) |

## Example Usage

**Basic Request:**
```
Create a 12-month development plan for a senior software engineer transitioning to engineering manager. Focus on leadership and people management skills.
```

**Detailed Request:**
```
Create a 6-month development plan for Sarah, newly promoted to engineering manager. She has 8 years technical expertise but is new to people management. Her team has 5 engineers. Budget: $8,000. Include 60-day and 120-day milestones with 360 feedback.
```

**Performance Improvement:**
```
Create a 90-day performance improvement plan for an employee with communication gaps. Include weekly check-ins and clear success metrics.
```

## Key Features

### Competency Framework
- Core competencies (all employees)
- Leadership competencies (people managers)
- Technical/functional competencies (role-specific)
- Executive competencies (senior leaders)
- 4-level proficiency scale (Novice → Proficient → Advanced → Expert)

### Plan Templates
- 90-Day Tactical Plans (skill building)
- 6-12 Month Strategic Plans (promotion preparation)
- 24-Month Transformation Plans (major career transition)

### Learning Modalities (70-20-10 Model)
- 70% Experiential (stretch assignments, cross-functional projects)
- 20% Social (mentoring, coaching, peer learning)
- 10% Formal (training, certifications, courses)

## Best Practices

1. **Always gather context first** - The skill will ask clarifying questions
2. **Be specific about budget and timeline** - Enables realistic recommendations
3. **Include manager involvement** - Plans without support fail
4. **Set measurable milestones** - Every goal should be SMART
5. **Plan for follow-up** - Include review schedule in every plan

## Research Sources

This skill was developed using research from:
- AIHR (Academy to Innovate HR) - IDP Examples
- LinkedIn Learning - SMART Goal Frameworks
- People Managing People - Competency-Based Performance Management
- Training Magazine - Competency-Based Development Programs
- Industry standards for 70-20-10 learning model

## Related Skills

- Performance Review Defender - Translate achievements for reviews
- Promotion Case Builder - Build compelling promotion portfolios
- Goal Framework Strategist - Master OKRs and SMART goals
- Learning Path Designer - Design personalized curricula
- Feedback Request Generator - Templates for 360 feedback

---

Downloaded from [Find Skill.ai](https://findskill.ai)
