---
name: flat-hierarchy-culture-designer
version: 1.0.0
---

# Flat Hierarchy Culture Designer - Initialization

Design and implement flat organizational structures with distributed authority, self-managed teams, psychological safety, and scalable decision-making frameworks.

## What This Skill Does

This skill transforms you into an expert organizational design consultant specializing in:
- Flat and agile organizational structures
- Self-managed team implementation
- Psychological safety foundation building
- Decision-making framework design (advice process, consent, Holacracy)
- Scaling organizations while preserving flat principles

## Target Users

- Founders and CEOs of growth-stage companies (50-500 employees)
- HR leaders and organizational development professionals
- Agile coaches and transformation specialists
- Team leads transitioning to flat structures
- Small-to-medium business owners seeking organizational redesign

## Structure

```
flat-hierarchy-culture-designer/
├── SKILL.md    # Main skill prompt with 7 core capabilities
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Initialization Steps

### For Claude Code

```bash
# Copy the skill to your Claude skills directory
cp -r flat-hierarchy-culture-designer/ ~/.claude/skills/flat-hierarchy-culture-designer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Quick Start

After installation, try these prompts:

**Designing Domain Ownership:**
```
I have an engineering team of 12 people and a product team of 8.
Both report to the same person in my current structure. I want to
move to domain ownership where they make autonomous decisions.
Help me design the domain boundaries and decision rights.
```

**Building Psychological Safety:**
```
We tried going flat 18 months ago but it's not working. Employees
report feeling lost, informal power dynamics have emerged. Give me
a 12-week plan to rebuild trust and psychological safety.
```

**Implementing Advice Process:**
```
We want to adopt the advice process for major decisions. Currently
decisions are made top-down or stuck in consensus. Give me a
decision classification framework and advice-seeking template.
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `organization_size` | `100` | Current number of employees |
| `decision_authority_model` | `advice_process` | Decision approach: advice_process, consensus, consent, domain_owner, hybrid |
| `psychological_safety_baseline` | `medium` | Current trust level: low, medium, high |
| `transparency_depth` | `moderate` | Info sharing: minimal, moderate, deep |
| `organization_scale_phase` | `growth` | Phase: startup (0-50), growth (50-250), scaling (250+) |
| `coordination_style` | `lightweight` | Coordination: lightweight, circles, functional, matrix |

## Key Capabilities

1. **Authority Distribution Design** - Map decision-making rights across roles
2. **Psychological Safety Foundation** - Build trust-based cultures
3. **Communication Protocol Development** - Design transparent information flow
4. **Self-Managed Team Implementation** - Create team charters and training
5. **Decision-Making Frameworks** - Implement advice process, consent-based decisions
6. **Scaling & Growth Management** - Evolve structure as organization grows
7. **Culture & Values Alignment** - Embed flat principles operationally

## Success Metrics

| Metric | Target |
|--------|--------|
| Decision Speed | Small: hours, Major: days |
| Psychological Safety | 4+ out of 5 |
| Autonomous Decisions | 70-80% without escalation |
| Conflict Resolution | 1-2 weeks average |

## Research Sources

- Holacracy.org - Self-management frameworks
- Radical Candor - Collaboration vs dominance hierarchies
- Google Project Aristotle - Psychological safety research
- Buurtzorg - Self-managed healthcare teams case study

---

Downloaded from [Find Skill.ai](https://findskill.ai)
