---
name: grant-funder-research
version: 1.0.0
---

# Initialization

Grant Funder Research helps nonprofit organizations identify and evaluate foundation, government, and corporate grant opportunities aligned with their mission using systematic research methodology and alignment scoring.

## Structure

- `SKILL.md` - Main skill prompt with funder research frameworks

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r grant-funder-research/ ~/.claude/skills/grant-funder-research/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{organization_type}}` | `501(c)(3) nonprofit` | Tax status and structure of the organization |
| `{{geographic_focus}}` | `National` | Service area for geographic filtering |
| `{{program_area}}` | `Education` | Primary issue area for funder alignment |
| `{{grant_size_range}}` | `$25,000-$100,000` | Target grant amount range |
| `{{funding_type}}` | `Program support` | Type of funding needed (program, operating, capital) |

## Key Features

### Research Databases Covered
- **Candid** - 324,000+ grantmaker profiles with 990 data
- **GrantWatch** - Real-time RFP listings and deadline tracking
- **Instrumentl** - AI-powered grant matching
- **Grants.gov** - Federal discretionary grants
- **State/Local portals** - Regional funding opportunities

### Alignment Assessment
7-criteria scoring framework (35-point scale):
1. Mission alignment
2. Geographic match
3. Population focus
4. Grant size fit
5. Organizational stage match
6. Funding type alignment
7. Track record with similar organizations

### Output Deliverables
- Funder research profiles with contact info
- Alignment scorecards with priority ratings
- Annual grant calendars by deadline
- Prospect research reports with recommendations
- LOI planning timelines
- Relationship tracking templates

## Example Usage

```
Find foundation grants for our youth mentorship program in Chicago.
We're a 501(c)(3) serving low-income teens ages 14-18 with after-school
tutoring and career mentorship. Annual budget is $450,000 and we're
seeking grants in the $25,000-$75,000 range. Focus on foundations that
fund education and youth development in Illinois.
```

## Related Skills

- **Grant Proposal Writer** - Write compelling proposals after identifying funders
- **Donor Communication Templates** - Build funder relationships through stewardship
- **Impact Report Generator** - Create reports demonstrating outcomes to funders

---
Downloaded from [Find Skill.ai](https://findskill.ai)
