---
name: interview-rubric-generator
version: 1.0.0
---

# Interview Rubric Generator - Initialization

Generate structured scoring rubrics and STAR-format interview questions for any role. This skill helps HR managers, recruiters, and hiring managers create competency-based evaluation frameworks that reduce bias and improve hiring decisions.

## Structure

```
interview-rubric-generator/
├── SKILL.md    # Main skill prompt with full interview design methodology
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code Installation
```bash
# Copy to Claude Code skills directory
cp -r interview-rubric-generator/ ~/.claude/skills/interview-rubric-generator/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy the content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's custom instructions or as a system prompt

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{job_title}}` | `Software Engineer` | The specific role being hired for |
| `{{experience_level}}` | `mid-level` | Career stage: entry-level, mid-level, senior, executive |
| `{{competency_count}}` | `7` | Number of core competencies to assess (5-8 recommended) |
| `{{rating_scale}}` | `0-5` | Scoring scale: 0-5 or 1-4 |
| `{{interview_format}}` | `behavioral` | Type: behavioral, technical, situational, mixed |
| `{{interview_duration_minutes}}` | `45` | Target interview length in minutes |
| `{{cultural_fit_weight}}` | `0.3` | Weight for cultural/soft skills (0.0-1.0) |

## Core Capabilities

1. **Generate Role-Specific Scoring Rubrics** - Create evaluation matrices with competency definitions, behavioral anchors, and rating scales
2. **Develop STAR-Format Interview Questions** - Build behavioral and situational questions mapped to competencies
3. **Design Multi-Stage Screening Processes** - Structure pre-screening, phone screening, and in-depth assessment phases
4. **Create Technical Assessment Rubrics** - Develop coding/design evaluation frameworks
5. **Build Cultural Fit Assessments** - Generate questions evaluating collaboration and team dynamics
6. **Generate Interview Panel Guidance** - Produce interviewer training materials and scoring guidelines
7. **Produce Hiring Recommendation Frameworks** - Create scoring aggregation and decision thresholds

## Key Concepts

- **STAR Method**: Situation, Task, Action, Result - framework for behavioral questions
- **Behavioral Anchors**: Specific observable behaviors for each score level
- **Competency-Based Interview**: Questions mapped to job-relevant competencies
- **Bias Mitigation**: Structural protections against affinity, halo, and confirmation bias

## Example Usage

```
I'm hiring a Senior Product Manager for a B2B SaaS company. Create:
- 6 core competencies (strategic thinking, stakeholder management, execution)
- 0-5 rating scale with behavioral anchors
- 2 STAR-format questions per competency
- Red flag indicators
- Scoring guidance for final hiring decision
```

## Related Skills

- **Candidate Screener** - Screen resumes before interviews
- **Job Description Writer** - Write clear job postings
- **Hiring Decision Validator** - Validate final hiring decisions
- **Performance Review Generator** - Set performance expectations

---
Downloaded from [Find Skill.ai](https://findskill.ai)
