---
name: performance-feedback-synthesizer
version: 1.0.0
---

# Performance Feedback Synthesizer - Initialization

Transform raw performance data into specific, actionable, and bias-aware feedback using proven frameworks (SBI, SKS, STAR, DESC, CEDAR). Synthesize 360-degree feedback, detect bias patterns, and generate development plans.

## Package Structure

```
performance-feedback-synthesizer/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None - this is a prompt-only skill. All functionality is contained in SKILL.md.

## Post-Installation Steps

### Claude Code (Recommended)
```bash
# Copy skill to Claude Code skills directory
cp -r performance-feedback-synthesizer/ ~/.claude/skills/performance-feedback-synthesizer/

# Verify installation
ls ~/.claude/skills/performance-feedback-synthesizer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy everything after the YAML frontmatter (after the second `---`)
3. Paste into a new conversation or custom instructions
4. Start using by providing employee performance data

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{feedback_framework}}` | `sbi` | Feedback model: sbi, sks, star, desc, cedar |
| `{{feedback_tone}}` | `constructive_supportive` | Voice: directive, coaching, formal, developmental |
| `{{data_sources}}` | `manager, metrics, peer` | Priority order for weighting feedback sources |
| `{{development_emphasis}}` | `balanced` | Focus: growth-focused, accountability-focused, balanced |
| `{{bias_check}}` | `enabled` | AI bias detection: enabled or disabled |

## Quick Start Examples

### Example 1: Annual Review with SBI Framework
```
I need to write Q4 feedback for Sarah, a Product Manager.

Performance Data:
- Goals: Launch 3 features, improve team efficiency by 15%
- Results: Launched 4 features, achieved 22% efficiency gain
- Peer feedback: Strong collaboration, design team mentions alignment issues
- Self-assessment: Rates execution highly, acknowledges communication gaps

Use the SBI framework with a coaching tone. Create comprehensive feedback.
```

### Example 2: 360-Degree Feedback Synthesis
```
Synthesize 360 feedback for James, Sales Director:

Manager: Strong revenue performer, needs process discipline
Peers: Great team builder but aggressive in cross-functional meetings
Direct Reports: Supportive but sets unrealistic expectations
Customers: Satisfied but mention feeling pressured
Self: Rates highly across all dimensions

Use SKS framework, identify blind spots, formal tone.
```

### Example 3: Performance Improvement Plan
```
Engineer Marcus has performance issues:
- Missed 3 of 5 sprint commitments (30% velocity shortfall)
- Code quality is strong when delivered
- Team members report communication gaps

Create a 90-day PIP using DESC framework with specific metrics and supportive tone.
```

## Key Capabilities

1. **Multi-Source Synthesis** - Aggregate manager, peer, self, and stakeholder feedback
2. **Framework Application** - SBI, SKS, STAR, DESC, CEDAR models
3. **Bias Detection** - Flag gendered language, recency bias, halo/horns effect
4. **Development Planning** - SMART goals, skill gap analysis, learning paths
5. **PIP Generation** - Structured improvement plans with measurable criteria
6. **Competency Feedback Banks** - Pre-built language for common competencies

## Supported Feedback Frameworks

| Framework | Best For | Structure |
|-----------|----------|-----------|
| **SBI** | Specific behavioral feedback | Situation → Behavior → Impact |
| **SKS** | Forward-looking development | Stop → Keep → Start |
| **STAR** | Achievement documentation | Situation → Task → Action → Result |
| **DESC** | Difficult conversations | Describe → Express → Specify → Consequences |
| **CEDAR** | Coaching conversations | Context → Examples → Diagnosis → Actions → Review |

## Integration Tips

- Combine with `feedback-request-generator` to collect 360 input
- Use with `goal-framework-strategist` for SMART goal creation
- Pair with `performance-review-defender` for employee self-advocacy prep

---
Downloaded from [Find Skill.ai](https://findskill.ai)
