---
name: recruitment-pipeline-manager
version: 1.0.0
---

# Initialization

AI-powered recruitment pipeline management system for agencies and talent acquisition teams. Manages candidate workflows, automates follow-ups, tracks stage progression, and reactivates Silver Medalist candidates for faster placements.

## Structure

- `SKILL.md` - Main skill prompt with pipeline management instructions

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r recruitment-pipeline-manager/ ~/.claude/skills/recruitment-pipeline-manager/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Recruitment Pipeline Manager")
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{pipeline_stage_names}}` | `Sourced, Screened, Phone Screen, Interview, Offer, Hired` | Customize stage names to match your recruitment process |
| `{{follow_up_cadence_days}}` | `Sourced: 5, Screened: 3, Interview: 5, Offer: 1` | Days before follow-up reminder at each stage |
| `{{quality_of_hire_threshold}}` | `4.0` | Minimum hiring manager feedback score (out of 5) to progress |
| `{{candidate_engagement_weight}}` | `email_open: 0.2, link_click: 0.3, response: 0.5` | Weights for engagement scoring algorithm |
| `{{silver_medalist_reactivation_months}}` | `6` | Months back to look for past candidates to reactivate |
| `{{auto_rejection_days_inactive}}` | `14` | Days without response before auto-rejection |

## Key Features

### Pipeline Stages
Default: Sourced → Screened → Phone Screen → Interview → Offer → Hired

Customize by modifying `pipeline_stage_names` variable.

### Follow-Up Automation
Built-in cadence recommendations:
- Sourced: 48h initial, +5 days, +10 days (archive)
- Interview scheduled: 24h before, 2h before, post-interview same day
- Offer: Same day, +24h, +48h deadline

### Silver Medalist Reactivation
Criteria for reactivation:
- Interviewed in past 6-12 months
- Feedback score 4.0+ out of 5
- Not hired due to budget, timing, or competing offer
- No "do not contact" flag

### Engagement Scoring
| Activity | Points |
|----------|--------|
| Email opened | 5 |
| Link clicked | 10 |
| Form submitted | 20 |
| Response sent | 25 |
| Interview attended | 50 |

Score interpretation:
- 0-30: Cold (archive/reactivate)
- 31-60: Warm (personalized follow-up)
- 61-85: Hot (accelerate)
- 86-100: Very Hot (fast-track)

## Example Usage

### Daily Pipeline Briefing
```
Give me a 5-minute morning briefing on my recruitment pipeline.
What candidates need follow-up today? Any bottlenecks?
Highlight anyone who might ghost if not contacted soon.
```

### Silver Medalist Campaign
```
We just opened a Sales Manager role. Who from my past 12 months
of candidates could be a great fit? Help me design a re-engagement campaign.
```

### Candidate Follow-Up
```
Alex, a Backend Engineer candidate, applied 7 days ago but hasn't
responded to my screening questions. What should I do?
Give me a custom outreach message that feels personal.
```

## Integration Notes

Compatible with major ATS/CRM platforms:
- **ATS:** Workable, Lever, Greenhouse, Bullhorn, ICIMS
- **CRM:** Phenom, Beamery, Gem, HubSpot
- **Sourcing:** LinkedIn Recruiter, Loxo, HireEZ

The skill provides templates and guidance that can be adapted to any platform's workflow.

---

Downloaded from [Find Skill.ai](https://findskill.ai)
