---
name: reference-check-script-writer
version: 1.0.0
---

# Initialization

Reference Check Script Writer helps HR professionals, recruiters, and hiring managers create structured, legally-compliant reference check scripts with STAR-based probing questions, competency rating rubrics, and 360-degree feedback templates.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive reference check methodology

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r reference-check-script-writer/ ~/.claude/skills/reference-check-script-writer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Reference Check Script Writer")
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{job_role}}` | `Software Engineer` | The specific job title/role being hired for |
| `{{experience_level}}` | `mid` | Career stage: entry, mid, senior, or executive |
| `{{competency_count}}` | `3` | Number of competencies to assess (2-5) |
| `{{assessment_depth}}` | `competency-based` | Type: verification-only, competency-based, or hybrid |
| `{{company_context}}` | `mid-market` | Organization type: startup, scale-up, mid-market, enterprise, government, nonprofit |
| `{{reference_diversity}}` | `three-level` | Referee strategy: supervisor-only, supervisor-peer, three-level |

## Key Capabilities

1. **Structured Script Generation** - Complete call scripts with intro, verification, competency questions, and closing
2. **Role-Based Question Banks** - Pre-built questions for technical, leadership, sales, customer-facing, and admin roles
3. **STAR Probing Methodology** - Behavioral interview integration with situation-task-action-result follow-ups
4. **Rating Rubrics** - 0-5 scales with behavioral anchors for objective competency assessment
5. **360-Degree Templates** - Multi-perspective scripts for supervisor, peer, and subordinate referees
6. **Compliance Safeguards** - Built-in avoidance of prohibited topics (age, disability, race, family status)
7. **Documentation Forms** - Summary sheets and integration matrices for consistent record-keeping

## Use Cases

- Creating reference check scripts for specific job openings
- Designing competency rating rubrics with behavioral indicators
- Building 360-degree feedback coordination templates
- Generating role-specific question banks (engineering, sales, leadership, etc.)
- Ensuring legal compliance and bias mitigation in hiring processes
- Training hiring managers on structured reference check methodology

## Example Usage

```
"Create a reference check script for an Engineering Manager position.
We're assessing Team Leadership, Technical Judgment, and Cross-Functional
Collaboration. Use the STAR method for probing. Include a 0-5 rating
rubric with behavioral anchors. The script should take ~30 minutes."
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
