---
name: remote-work-policy-writer
version: 1.0.0
---

# Remote Work Policy Writer - Initialization

An expert HR policy consultant skill that drafts compliant, comprehensive remote and hybrid work policies covering multi-state employment law, ADA accommodations, data security, and flexible work arrangements for distributed workforces.

## What This Skill Does

Transforms the AI into an HR policy specialist that helps organizations create:
- Complete remote/hybrid work policy documents (14 comprehensive sections)
- Multi-state compliance addendums
- ADA accommodation procedures
- Security protocols for distributed teams
- Manager and employee FAQs
- Supporting forms and checklists

## Target Users

- HR Managers & Directors
- Small Business Owners
- Legal Compliance Teams
- Organizational Development Professionals
- Managers implementing remote work standards
- HR Consultants

## Structure

```
remote-work-policy-writer/
├── SKILL.md     # Main skill prompt (comprehensive policy framework)
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md contains the complete policy generation framework.

## Post-Init Steps

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude Code skills directory
cp -r remote-work-policy-writer/ ~/.claude/skills/remote-work-policy-writer/
```

Then invoke with: "Use the remote-work-policy-writer skill to help me create a remote work policy"

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a system prompt or at the start of conversation
4. Then describe your organization and policy needs

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the full skill content
3. Paste into your AI assistant
4. Provide your organization details when prompted

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `company_size` | `mid-market` | Organization size: startup, small (1-50), mid-market (50-500), enterprise (500+) |
| `work_model` | `hybrid` | Remote work structure: fully_remote, hybrid, flexible, or mixed |
| `geographic_scope` | `single_state` | Compliance scope: single_state, multi_state, or international |
| `security_level` | `standard` | Data protection tier: standard, high (healthcare/finance), highest (government) |
| `industry` | `general` | Industry sector for specialized compliance requirements |
| `focus_areas` | `compliance, flexibility, security` | Policy emphasis priorities |

## Example Usage

**Basic Request:**
```
Create a hybrid work policy for a 150-person software company in California
with 20% of staff in Texas. We want employees in-office Tuesday-Thursday
with flexible Mondays and Fridays.
```

**Detailed Request:**
```
I need a comprehensive remote work policy for our healthcare company (200 employees)
with staff in California, Texas, and New York. Requirements:
- Hybrid model: 2 days in-office, 3 days remote
- High security due to HIPAA requirements
- Need ADA accommodation procedures for pending requests
- Include equipment stipend policy ($100/month)
- Address time zone challenges (PST to EST)
```

**Compliance-Focused Request:**
```
We're a multi-state professional services firm (12 states, 200 employees).
Our current policy is from 2022 and doesn't reflect recent legal changes.
Generate updated policy sections for meal breaks, expense reimbursement,
and pay transparency compliance.
```

## Policy Sections Generated

The skill produces policies covering:

1. **Purpose and Scope** - Policy objectives and applicability
2. **Definitions** - Key terms (telework, hybrid, core hours, etc.)
3. **Eligibility Criteria** - Position and employee requirements
4. **Work Schedules** - Hours, core hours, flexibility, overtime
5. **Communication** - Channels, response times, meeting guidelines
6. **Performance** - Standards, goal-setting, accountability
7. **Equipment** - Company-provided and employee-provided items
8. **Data Security** - Network, device, data handling, BYOD
9. **Workspace** - Home office standards, safety, expenses
10. **Health & Well-Being** - Work-life balance, mental health, isolation
11. **Legal Compliance** - Multi-state, tax, workers' comp
12. **ADA Accommodations** - Request process, essential functions, alternatives
13. **Policy Administration** - Ownership, agreements, modifications
14. **Appendices** - Forms, checklists, state addendums

## Compliance Coverage

**Federal Laws:**
- FLSA (Fair Labor Standards Act)
- ADA (Americans with Disabilities Act)
- FMLA (Family and Medical Leave Act)
- OSHA workplace safety
- PWFA (Pregnant Workers Fairness Act)

**State-Specific Guidance:**
- California (meal breaks, expense reimbursement, pay transparency)
- New York (paid family leave, salary history ban)
- Texas (federal minimums)
- Multi-state tax nexus considerations

**Security Standards:**
- Standard (general business)
- High (healthcare/finance - HIPAA, GLBA)
- Highest (government contracts - NIST, FedRAMP)

## Output Deliverables

For each policy request, the skill generates:
- Executive Summary (1 page)
- Full Policy Document (14 sections)
- Manager FAQ
- Employee FAQ
- Eligibility Checklist
- Home Office Setup Checklist
- Security Compliance Checklist
- Remote Work Agreement Template
- Accommodation Request Form

## Best Practices Embedded

- Trust-based management over surveillance
- Outcome-focused performance metrics
- Right-to-disconnect provisions
- Proactive accommodation design
- Multi-state compliance as foundation
- Regular policy review cycles
- Clear, plain language documentation

---
Downloaded from [Find Skill.ai](https://findskill.ai)
