---
name: saas-tos-analyzer
version: 1.0.0
---

# SaaS ToS Analyzer - Initialization

Audit SaaS Terms of Service for customer liability risks, unfair clauses, compliance gaps (GDPR, HIPAA, SOC 2), and indemnification asymmetries with market benchmarking data.

## What This Skill Does

This skill transforms your AI assistant into an expert SaaS contract analyst that:

1. **Extracts & Categorizes** all liability, indemnification, data protection, and termination clauses
2. **Scores Risk** on a 1-10 scale with business impact explanations
3. **Detects Unfair Terms** including asymmetric obligations and hidden clauses
4. **Benchmarks Against Market** using industry-standard data (TermScout, ToS;DR)
5. **Generates Negotiation Language** with specific alternative clause wording
6. **Maps Compliance Requirements** for GDPR, HIPAA, SOC 2, PCI-DSS

## Package Structure

```
saas-tos-analyzer/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
├── INIT.md     # This file - setup instructions
└── index.md    # Hugo page (for findskill.ai display only)
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Create skills directory if needed
mkdir -p ~/.claude/skills/

# Copy skill folder to Claude skills directory
cp -r saas-tos-analyzer/ ~/.claude/skills/saas-tos-analyzer/
```

Then reference in your project's CLAUDE.md:

```markdown
## Available Skills

| Skill | Location | Use When |
|-------|----------|----------|
| SaaS ToS Analyzer | `~/.claude/skills/saas-tos-analyzer/` | Auditing vendor Terms of Service |
```

### ChatGPT / Gemini / Copilot / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into a new conversation or custom instructions
4. Begin using by providing a ToS document

## Usage Examples

### Pre-Purchase Vendor Evaluation

```
I'm evaluating a contract with [Vendor Name] for enterprise CRM.
We're in healthcare (HIPAA-regulated), handle EU customer data (GDPR applies),
and have annual contract value of $250K.

Please:
1. Audit the entire ToS for liability and indemnification clauses
2. Check for required HIPAA BAA and GDPR DPA compliance
3. Flag any auto-renewal traps or unilateral modification rights
4. Compare liability cap against market standard for healthcare SaaS
5. Identify top 5 negotiation points with market-standard language

Here's the ToS:
[Paste ToS text or URL]
```

### Compliance Gap Analysis

```
We've been using [SaaS Vendor] for 18 months and just got audited.
Please review our contract against these requirements:
- GDPR Data Processing Agreement (we process EU customer data)
- SOC 2 Type II audit rights
- HIPAA BAA (we recently expanded to healthcare customers)

What gaps exist and what amendments do we need?

Here's our contract:
[Paste contract text]
```

### Indemnification Negotiation

```
I'm negotiating with [B2B SaaS Vendor] next week. Their customer
indemnification clause is very broad - they want us to indemnify for
"any claims related to data uploaded to the platform."

Please:
1. Analyze their indemnity language and flag issues
2. Show me market standards for this type of SaaS
3. Provide negotiation talking points and alternative language
4. Identify carve-outs or limits I should push for

Here's the relevant section:
[Paste indemnification clause]
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{risk_threshold_high}}` | `7` | Minimum score (1-10) for HIGH-RISK flagging |
| `{{max_liability_cap_percent}}` | `150` | Max acceptable liability cap as % of 12-month fees |
| `{{required_compliance_frameworks}}` | `GDPR, SOC2` | Required compliance frameworks |
| `{{data_residency_required}}` | `EU` | Required data residency (EU, US, APAC, any) |
| `{{termination_notice_days}}` | `30` | Minimum acceptable termination notice (days) |
| `{{indemnity_scope_acceptable}}` | `third_party_only` | Acceptable indemnification scope |

## Key Features

### Risk Scoring (1-10)

| Score | Level | Action |
|-------|-------|--------|
| 9-10 | CRITICAL | Must negotiate or walk away |
| 7-8 | HIGH | Strongly recommend change |
| 5-6 | MEDIUM | Review with stakeholders |
| 3-4 | LOW | Consider if leverage exists |
| 1-2 | ACCEPTABLE | No action needed |

### Automatic High-Risk Flags

The skill automatically flags:
- Unlimited liability
- Broad customer indemnification ("any and all claims")
- Direct claims in indemnity (beyond third-party)
- Auto-renewal with <60 days notice
- Unilateral modification rights
- Breach notification >72 hours (GDPR violation)
- No audit rights
- Waiver of jury trial

### Compliance Frameworks

| Framework | Key Requirements |
|-----------|-----------------|
| GDPR | DPA, breach <72h, deletion rights, sub-processor list |
| HIPAA | BAA, encryption, access controls, breach notification |
| SOC 2 | Annual certification, security incident reporting |
| PCI DSS | Encryption, access controls, monitoring |

### Market Benchmarks

| Term | Market Standard | Red Flag |
|------|-----------------|----------|
| Liability Cap | 150% of 12-month fees | <100% |
| Auto-Renewal Notice | 60+ days | <30 days |
| Termination Notice | 30-90 days | >90 days |
| Data Access Window | 60 days | <30 days |
| Breach Notification | 48-72 hours | >72 hours |

## Output Formats

The skill provides structured output including:

1. **Executive Summary** - 1 paragraph overview with recommendation
2. **Risk Heat Map** - Category scores in table format
3. **Top Issues** - Prioritized list with quotes and alternatives
4. **Compliance Status** - Pass/Fail/Partial for each framework
5. **Liability Analysis** - Calculated cap in dollars with benchmarks
6. **Negotiation Strategy** - Must-have vs. nice-to-have changes

## Legal Disclaimer

This skill provides **educational analysis only**, not legal advice. Always:
- Consult qualified legal counsel before signing contracts
- Use this analysis as input for legal review, not replacement
- Verify recommendations against applicable law in your jurisdiction

## Related Skills

- Contract Analyzer - General contract clause extraction
- GDPR Request Processor - Handle data subject requests
- Vendor Risk Assessment - Comprehensive vendor security evaluation
- HIPAA Documentation Generator - Generate BAA templates

---

Downloaded from [Find Skill.ai](https://findskill.ai)
