---
name: subcontractor-agreement-builder
version: 1.0.0
---

# Subcontractor Agreement Builder - Initialization

Generate legally compliant subcontracting agreements with proper indemnification structures, liability caps, insurance requirements, and state-specific compliance for construction projects.

## What This Skill Does

This skill transforms a 4-8 hour legal drafting process into a 30-60 minute workflow. It generates complete subcontractor agreements tailored to specific jurisdictions, project types, and risk profiles.

### Core Capabilities

- **Indemnification Structure Generation** - Select Broad, Intermediate, or Limited Form based on state law
- **Liability Cap Configuration** - Create enforceable limitation clauses with carveouts
- **Insurance Requirement Builder** - Specify GL, Workers Comp, Professional Liability, Pollution coverage
- **Payment & Retainage Terms** - Generate state-compliant payment schedules
- **Performance Bond Requirements** - Determine bond needs based on contract value
- **Dispute Resolution Clauses** - Produce mediation/arbitration procedures
- **Risk Allocation Matrix** - Map tasks to responsible parties

## Structure

```
subcontractor-agreement-builder/
├── SKILL.md          # Main skill prompt (copy to AI)
├── INIT.md           # This initialization file
└── index.md          # Website listing page
```

## Files to Generate

None required. This is a prompt-only skill that generates agreement documents interactively.

## Post-Init Steps

### For Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r subcontractor-agreement-builder/ ~/.claude/skills/subcontractor-agreement-builder/
```

Then add to your project's `.claude/settings.json`:

```json
{
  "skills": ["subcontractor-agreement-builder"]
}
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Start a new conversation and request a subcontractor agreement

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{contract_value_usd}}` | `100000` | Total contract value; determines if performance bond required |
| `{{indemnification_type}}` | `intermediate` | Legal form: broad, intermediate, or limited |
| `{{retainage_percentage}}` | `10` | Percentage withheld from each payment (5-15% typical) |
| `{{general_liability_coverage_usd}}` | `1000000` | Minimum GL insurance per occurrence |
| `{{payment_schedule_type}}` | `monthly_progress` | Billing frequency: weekly, bi-weekly, monthly_progress |
| `{{project_location_state}}` | `California` | State jurisdiction for compliance and anti-indemnity laws |

## Example Usage

```
Generate a subcontractor agreement for a commercial office renovation.
Electrical subcontractor, $85,000 contract value, located in California.
This is a repeat subcontractor we've used 5 times before. Need standard
GL insurance ($1M), no performance bond required (under $100K). Use
limited form indemnification per CA law. Include monthly progress billing
with 10% retainage. Add 30-day mediation requirement before arbitration.
Scope: Supply and install new power distribution, outlets, LED fixtures,
and emergency lighting per drawings A-4.1 through A-4.6. Excludes solar
system, backup generator, and data cabling.
```

## Key Features

### Three Indemnification Types

| Type | When to Use | States Where Limited |
|------|-------------|---------------------|
| **Broad Form** | Maximum contractor protection | CA, TX, CO, WA, IL, NJ |
| **Intermediate Form** | Commercial construction standard | Most states allow |
| **Limited Form** | Balanced risk allocation | Required in anti-indemnity states |

### Insurance Requirements by Trade

| Trade | Minimum GL | Special Coverage |
|-------|-----------|-----------------|
| Electrical | $1M/$2M | Pollution if panel work |
| HVAC | $1M/$2M | Refrigerant pollution |
| Roofing | $2M/$4M | Excess liability |
| Excavation | $2M/$4M | Pollution, underground |
| Hazmat | $2M/$5M | Pollution $2M minimum |
| Demolition | $2M/$4M | Pollution, excess |

### Performance Bond Thresholds

| Contract Value | Requirement |
|---------------|-------------|
| Under $50K | Retainage only |
| $50K - $100K | Optional bond |
| $100K - $500K | Bond recommended |
| $500K+ | Bond required |
| Public Works | Statutory requirement |

## Important Disclaimer

This skill generates template language for educational and reference purposes. All agreements MUST be reviewed by a qualified construction attorney licensed in the relevant jurisdiction before execution. Laws vary significantly by state and project type.

## Related Skills

- [Contract Analyzer](/skills/productivity/contract-analyzer/) - Analyze existing contracts
- [Contract Reviewer](/skills/productivity/contract-reviewer/) - Review for red flags
- [Construction Estimate Generator](/skills/industry/construction-estimate-generator/) - Create cost estimates
- [Financial Risk Assessment](/skills/industry/financial-risk-assessment/) - Evaluate financial risks
- [Negotiation Stance Builder](/skills/productivity/negotiation-stance-builder/) - Build negotiation strategies

---
Downloaded from [Find Skill.ai](https://findskill.ai)
