---
name: supply-chain-risk-analyzer
version: 1.0.0
---

# Supply Chain Risk Analyzer - Initialization

Transform supply chain vulnerability into competitive advantage with structured risk assessment, scenario planning, and diversification strategies using SCOR, FMEA, and AHP frameworks.

## Package Contents

```
supply-chain-risk-analyzer/
├── SKILL.md       # Main skill prompt (copy to AI assistant)
└── INIT.md        # This initialization file
```

## Quick Start

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r supply-chain-risk-analyzer/ ~/.claude/skills/supply-chain-risk-analyzer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "You are a Supply Chain Risk Analyst...")
3. Paste into your AI assistant as a system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{risk_assessment_framework}}` | `scor` | Framework: scor, fmea, ahp, or custom |
| `{{risk_categories_included}}` | `supply, manufacturing, distribution, financial, cyber, geopolitical, environmental` | Risk categories to evaluate |
| `{{geographic_regions}}` | `North America, Europe, Asia Pacific` | Regions for concentration analysis |
| `{{time_horizon_years}}` | `5` | Assessment period (1-10 years) |
| `{{risk_tolerance_threshold}}` | `10` | Risk score requiring mitigation (0-25) |
| `{{diversification_cost_tolerance_percent}}` | `5` | Cost increase tolerance for diversification |

## Core Capabilities

1. **Risk Identification & Mapping** - Systematic vulnerability identification across 7 categories
2. **Multi-Dimensional Risk Assessment** - Probability × Impact scoring with priority matrix
3. **Vulnerability Prioritization** - Criticality-weighted supplier and component ranking
4. **Diversification Strategy** - Nearshoring, onshoring, friendshoring recommendations
5. **Scenario Planning** - Disruption modeling with Time to Recover analysis
6. **Compliance Monitoring** - ISO 31000, ISO 22301, industry-specific tracking

## Risk Frameworks Included

- **SCOR Model** - Plan/Source/Make/Deliver/Return risk mapping
- **FMEA** - Failure Mode and Effects Analysis with RPN scoring
- **AHP** - Analytic Hierarchy Process for multi-criteria prioritization

## Example Usage

```
Analyze our electronics manufacturing supply chain. We source semiconductors
from 3 suppliers: TSMC (Taiwan, 60%), Samsung (South Korea, 35%), Intel (US, 5%).
Current lead time is 8 weeks. Identify single-source risks, geopolitical
vulnerabilities, and recommend diversification options within 10% cost tolerance.
```

## Expected Outputs

- Risk Priority Matrix (Critical/High/Medium/Low)
- Supplier Vulnerability Heat Map
- Geographic Concentration Analysis
- Diversification Roadmap with ROI
- Scenario Impact Assessments
- Implementation Timeline

## Related Skills

- Business Continuity Plan Generator
- Vendor Risk Assessment
- Financial Risk Assessment
- Supply Chain Analytics
- Predictive Analytics

## Industry Applications

- Manufacturing & Automotive
- Pharmaceuticals & Healthcare
- Electronics & Semiconductors
- Aerospace & Defense
- Fast-Moving Consumer Goods (FMCG)
- Food & Beverage
- Technology & Software

---

Downloaded from [Find Skill.ai](https://findskill.ai)
