---
name: vendor-risk-assessment
version: 1.0.0
---

# Initialization

Create third-party vendor risk assessment questionnaires for GDPR, SOC 2, and ISO 27001 compliance with scoring matrices.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r vendor-risk-assessment/ ~/.claude/skills/vendor-risk-assessment/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{vendor_name}}` | `Vendor Name` | Name of the vendor being assessed |
| `{{service_type}}` | `SaaS provider` | Type of service provided (SaaS, data processor, cloud hosting) |
| `{{data_access}}` | `full PII access` | Level of data access (none, limited, full PII access) |
| `{{compliance_requirements}}` | `GDPR, SOC 2 Type II` | Required compliance frameworks |

---
Downloaded from [Find Skill.ai](https://findskill.ai)