---
name: affiliate-agreement-generator
version: 1.0.0
---

# Affiliate Agreement Generator - Initialization

Generate legally-sound affiliate partnership agreements with FTC-compliant disclosure requirements, commission structures, clawback provisions, and termination clauses.

## What This Skill Does

This skill transforms you into an expert legal document specialist that creates comprehensive, enforceable affiliate partnership agreements. It helps merchants:

- Generate complete 8-12 page affiliate agreements
- Ensure FTC compliance with proper disclosure language
- Configure commission structures (percentage, CPA, tiered, hybrid)
- Define payment terms, clawback provisions, and termination procedures
- Protect intellectual property and brand usage
- Include GDPR/CCPA compliance for international programs

## Structure

```
affiliate-agreement-generator/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Create skills directory if it doesn't exist
mkdir -p ~/.claude/skills/affiliate-agreement-generator

# Copy the skill files
cp -r affiliate-agreement-generator/ ~/.claude/skills/affiliate-agreement-generator/
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as the system prompt or initial context
4. Begin using by providing your company and program details

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{commission_rate}}` | `15%` | Primary commission rate (percentage or fixed amount) |
| `{{payment_frequency}}` | `monthly` | How often commissions are paid (monthly, quarterly, bi-weekly) |
| `{{payout_threshold}}` | `$50` | Minimum balance before payment is triggered |
| `{{cookie_duration_days}}` | `30` | Days after click during which conversion is credited |
| `{{notice_period_days}}` | `30` | Days required for termination notice |
| `{{clawback_window_days}}` | `90` | Days within which commissions can be reclaimed |

## Quick Start

After installation, provide the skill with:

1. **Company Details**: Legal name, state of incorporation, website
2. **Business Type**: SaaS, e-commerce, digital products, or services
3. **Target Affiliates**: Agencies, influencers, content creators, consultants
4. **Commission Structure**: Percentage, CPA, tiered, or hybrid model
5. **Payment Terms**: Frequency, threshold, methods
6. **Promotional Guidelines**: Allowed and prohibited activities

### Example Prompt

```
Generate a professional affiliate agreement for TechFlow Inc., a Delaware-incorporated B2B SaaS company at techflow.io.

Commission: 25% of first-year subscription value
Payment: Monthly on the 15th, $100 minimum, ACH/PayPal
Cookie: 90 days
Affiliates: Marketing agencies and tech consultants
Allowed: Blogs, LinkedIn, webinars, email marketing
Prohibited: Brand keyword bidding, misleading claims
```

## Key Features

### 1. Comprehensive Clause Library
50+ pre-vetted legal clauses covering:
- Definitions and interpretation
- Commission structure and calculation
- Payment terms and procedures
- FTC compliance requirements
- Intellectual property rights
- Confidentiality provisions
- Prohibited activities
- Term and termination
- Indemnification
- Dispute resolution

### 2. FTC Compliance Module
Automatic inclusion of:
- Mandatory disclosure language
- Acceptable vs. unacceptable disclosure examples
- 2024 FTC Final Rule compliance (fake reviews prohibition)
- Disclosure placement requirements

### 3. Commission Structure Wizard
Pre-built templates for:
- Percentage of sale
- Fixed fee (CPA/CPL)
- Tiered structures
- Hybrid models
- Recurring commissions (SaaS)

### 4. Risk Detection
Flags problematic provisions:
- Missing FTC disclosure requirements
- Vague commission language
- No clawback window
- Contradictory jurisdiction clauses
- Missing termination procedures

## Industry Benchmarks

| Standard | Typical Range |
|----------|---------------|
| Cookie Duration | 7-90 days (30 most common) |
| Payment Frequency | Monthly |
| Payout Threshold | $50-$100 |
| Commission (E-commerce) | 5-15% |
| Commission (Digital) | 25-50% |
| Commission (SaaS) | 20-40% |
| Termination Notice | 30 days |
| Clawback Window | 60-90 days |

## Legal Disclaimer

Generated documents are templates based on industry best practices. They should be reviewed by qualified legal counsel before use. This is not legal advice. Users are responsible for ensuring agreements comply with applicable laws in their jurisdictions.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
