---
name: b2b-service-agreement-generator
version: 1.0.0
---

# B2B Service Agreement Generator - Initialization

Generate professional B2B service agreements for SaaS, consulting, IT services, and professional services with SLA configuration, liability caps, multi-jurisdiction compliance, and all essential contract clauses.

## Package Contents

```
b2b-service-agreement-generator/
├── SKILL.md       # Main skill prompt with full contract templates
└── INIT.md        # This initialization file
```

## Quick Start

### For Claude Code

```bash
# Copy to your skills directory
cp -r b2b-service-agreement-generator/ ~/.claude/skills/b2b-service-agreement-generator/

# The skill will be available immediately
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or as a custom instruction
4. Start using by asking to generate a service agreement

## What This Skill Does

This skill transforms your AI assistant into a B2B contract specialist that:

1. **Gathers requirements** through a guided questionnaire
2. **Recommends terms** based on contract value, industry, and risk profile
3. **Generates complete agreements** with all necessary sections
4. **Provides jurisdiction-specific** modifications (US, EU, UK, APAC)
5. **Offers negotiation guidance** for common client requests

## Agreement Sections Generated

- Parties and Recitals
- Definitions
- Services and Scope
- Fees and Payment
- Term and Termination
- Intellectual Property
- Confidentiality
- Service Level Agreement (SLA)
- Warranties and Disclaimers
- Limitation of Liability
- Indemnification
- Data Protection
- Insurance
- General Provisions
- Signature Block
- Exhibits

## Supported Agreement Types

| Type | Key Features |
|------|--------------|
| **SaaS** | Uptime SLAs, service credits, acceptable use |
| **Professional Services** | Deliverables, acceptance criteria, T&M caps |
| **IT Consulting** | Security, change management, compliance |
| **Staffing** | Placement guarantees, conversion terms |
| **Maintenance** | Response times, coverage hours |

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{contract_value_annual}}` | `50000` | Annual value in USD for liability calculations |
| `{{service_type}}` | `saas` | saas, consulting, freelance, staffing, maintenance |
| `{{jurisdiction}}` | `us_general` | us_general, eu_gdpr, uk, california, apac |
| `{{liability_cap_multiplier}}` | `12` | Months of fees for liability cap (6, 12, 24) |
| `{{sla_uptime_percentage}}` | `99.5` | Availability guarantee (99.0, 99.5, 99.9) |
| `{{ip_ownership_model}}` | `client_owns` | client_owns, provider_retains_license |

## Example Usage

### Basic SaaS Agreement

```
Generate a B2B SaaS agreement for a $50,000/year contract with Acme Corp.
We provide cloud-based inventory management software with 99.5% uptime SLA.
Liability capped at 12 months fees. Client owns custom configurations.
Delaware law. Net 30 payment terms.
```

### Professional Services Agreement

```
Create a consulting services agreement for a $120,000 project with
BigCo Industries. Deliverables: market analysis report, strategy
recommendations, and implementation roadmap. Fixed fee with 3 milestones.
T&M for additional work at $250/hour. We retain methodology IP, client
owns final deliverables. Include key personnel clause and NDA.
```

### Multi-Jurisdiction Enterprise Deal

```
Generate an EU-compliant B2B service agreement for a German enterprise
client worth €200,000 annually. SaaS platform with GDPR DPA required.
Need 99.9% uptime SLA with service credits. Include Standard Contractual
Clauses for data transfers. German law, English language.
```

## Key Features

### Liability Configuration
- Configurable caps (6, 12, 24 months of fees)
- Carve-outs for IP infringement, data breach, willful misconduct
- Mutual indemnification with industry-standard procedures

### SLA Framework
- Tiered severity levels with response/resolution targets
- Service credit calculations
- Comprehensive exclusions (maintenance, Force Majeure)

### IP Ownership Models
- Client owns work product (with provider license to pre-existing IP)
- Provider retains with license grant
- Shared ownership configurations

### Multi-Jurisdiction Support
- US (Delaware, California, New York)
- EU (GDPR, SCCs)
- UK (post-Brexit)
- APAC (Singapore arbitration)

## Important Disclaimers

1. **Not Legal Advice**: This generates template language for educational purposes
2. **Review Required**: All agreements should be reviewed by qualified legal counsel
3. **Jurisdiction Specific**: Laws vary significantly by location
4. **Customize**: Templates may not address your specific situation

## Related Skills

- [Master Service Agreement Generator](/skills/productivity/master-service-agreement/) - For MSA frameworks
- [Freelance Contract Generator](/skills/legal/freelance-contract-generator/) - For individual contractors
- [Licensing Agreement Architect](/skills/legal/licensing-agreement-architect/) - For IP licensing
- [Negotiation Stance Builder](/skills/productivity/negotiation-stance-builder/) - For contract negotiations

## Changelog

### v1.0.0 (2025-09-18)
- Initial release
- Full agreement templates for SaaS, consulting, IT services, staffing
- Multi-jurisdiction support (US, EU, UK, APAC)
- SLA configuration with service credits
- Comprehensive liability and indemnification clauses
- Data protection and GDPR compliance sections

---

Downloaded from [Find Skill.ai](https://findskill.ai)
