---
name: confidentiality-policy-writer
version: 1.0.0
---

# Initialization

Confidentiality Policy Writer - Draft employee NDAs, confidentiality agreements, and policy clauses tailored by role, jurisdiction, and risk level. Includes red-flag review of incoming NDAs and whistleblower-compliant language.

## Structure

```
confidentiality-policy-writer/
  SKILL.md     # Main skill prompt with full instructions
  INIT.md      # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r confidentiality-policy-writer/ ~/.claude/skills/confidentiality-policy-writer/
```

### ChatGPT / Gemini / Copilot
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of a conversation

### Custom GPT Setup
1. Create new GPT at chat.openai.com/gpts
2. Name: "Confidentiality Policy Writer"
3. Description: "Draft employee NDAs, confidentiality agreements, and policy clauses"
4. Paste SKILL.md content into Instructions
5. Set conversation starters:
   - "Draft an employee confidentiality agreement for a California software engineer"
   - "Review this NDA for red flags from an employee's perspective"
   - "Create a plain-English summary of confidentiality obligations"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{jurisdiction}}` | `US_generic` | Governing law jurisdiction (US_California, UK, EU_Germany, etc.) |
| `{{role_risk_level}}` | `standard` | Risk tier: standard, high_risk_trade_secret, or executive |
| `{{include_ip_assignment}}` | `true` | Include IP and invention assignment clauses |
| `{{post_employment_duration_years}}` | `3` | Years confidentiality survives after termination |
| `{{whistleblower_carveout_strength}}` | `standard` | Protection level: minimal, standard, or strong |
| `{{output_format}}` | `both` | Output: legal_text, plain_english_summary, or both |

## Capabilities

This skill enables you to:

1. **Draft Employee Confidentiality Agreements** - Complete agreements for new hires with role-specific definitions, obligations, and durations

2. **Create Role-Specific NDA Addenda** - Enhanced protections for engineers, sales, finance, healthcare, and executives

3. **Generate Policy Clauses** - Modular confidentiality language for handbooks, contracts, and codes of conduct

4. **Jurisdiction-Aware Drafting** - Adapt for US state variations, UK, EU/GDPR requirements, and whistleblower laws

5. **Red-Flag Review** - Analyze incoming NDAs for overbroad terms, missing protections, and negotiation points

6. **Plain-English Summaries** - Employee-friendly explanations of what agreements actually mean

## Example Usage

```
User: I'm hiring a senior software engineer at our California SaaS startup.
Draft an employee confidentiality agreement that protects our source code,
customer data, and business strategy. Include IP assignment for code they
write, standard whistleblower carve-outs, and a 3-year post-employment period.
Also give me a plain-English summary I can send with the offer letter.
```

## Key Features

### Confidential Information Categories
- **Trade Secrets**: Indefinite protection (algorithms, source code, formulas)
- **Business Confidential**: 2-5 years (customer lists, pricing, strategies)
- **Internal Information**: 1-2 years (policies, meeting notes)

### Standard Exclusions (Always Included)
- Publicly available information
- Employee's prior knowledge
- Independently developed information
- Third-party disclosures without restriction
- Legally compelled disclosures

### Whistleblower Protections
- Cannot prevent reporting illegal activities
- US DTSA notice included automatically
- EU Whistleblower Directive compliance

### Role-Specific Templates
| Role | Key Additions |
|------|---------------|
| Engineers | Source code, APIs, security, open source policy |
| Sales | Customer lists, pricing, LinkedIn policy |
| Finance | Financial data, M&A, insider trading |
| Healthcare | PHI, HIPAA, mandatory reporting |
| Executive | Strategy, board materials, garden leave |

## Legal Disclaimer

This skill generates template language for educational and drafting purposes. All agreements MUST be reviewed by qualified legal counsel before execution. Employment law varies significantly by jurisdiction.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
