---
name: contract-risk-analyzer
version: 1.0.0
---

# Contract Risk Analyzer - Initialization

AI skill for identifying financial, liability, and compliance red flags in contracts. Systematically assesses risk across seven dimensions: red flag detection, risk categorization, liability exposure, compliance verification, SLA analysis, clause completeness, and risk scoring.

## Structure

```
contract-risk-analyzer/
├── SKILL.md    # Main skill prompt (800+ lines)
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r contract-risk-analyzer/ ~/.claude/skills/contract-risk-analyzer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are an expert Contract Risk Analyst...")
3. Paste into AI assistant as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{contract_value_threshold}}` | `$100,000` | Minimum contract value triggering enhanced risk review |
| `{{risk_severity_levels}}` | `Critical, High, Medium, Low` | Categorization system for identified risks |
| `{{liability_cap_percentage}}` | `12 months fees` | Recommended maximum liability exposure as percentage of contract value |
| `{{audit_frequency_required}}` | `Annual` | Expected audit right frequency for vendor/third-party contracts |
| `{{renewal_notice_days}}` | `90` | Days before auto-renewal to trigger escalation alert |
| `{{compliance_frameworks}}` | `GDPR, HIPAA, SOC 2` | Industry/regulatory frameworks to screen against |

## Quick Start

After installation, use the skill by providing:
1. The contract text (paste directly or upload)
2. Contract value and term length
3. Your industry and applicable regulations
4. Specific concerns (liability, compliance, SLAs, etc.)

### Example Prompt
```
Analyze this 3-year, $500K SaaS vendor agreement for our data analytics platform.
Identify financial risks, liability exposure, data protection gaps, and compliance
issues. Flag red flags around indemnification, auto-renewal, termination rights,
and audit access. We have low risk tolerance for vendor contracts.
```

## Core Capabilities

1. **Red Flag Detection** - High-risk language, missing clauses, non-standard terms
2. **Risk Categorization** - Financial, liability, compliance, operational (Critical/High/Medium/Low)
3. **Liability Exposure** - Indemnification, insurance, damage caps quantification
4. **Compliance Verification** - GDPR, HIPAA, SOC 2, industry-specific checks
5. **SLA Analysis** - Metrics evaluation, penalty adequacy, enforceability
6. **Clause Completeness** - Essential clause checklist, gap identification
7. **Risk Scoring** - Weighted scoring matrix with escalation recommendations

## Included Workflows

- **Workflow 1**: Pre-Signature Risk Screening
- **Workflow 2**: Liability & Indemnification Analysis
- **Workflow 3**: Compliance Obligation Extraction
- **Workflow 4**: SLA Performance Metrics Review
- **Workflow 5**: Ongoing Compliance & Obligation Monitoring

## Key Concepts Covered

- Indemnification (scope, caps, carve-outs)
- Liability caps and exclusions
- Scope creep detection
- SLA SMART criteria evaluation
- Force majeure provisions
- Boilerplate language risks
- Liquidated damages
- Cure periods
- Termination rights
- Counterparty risk assessment
- Audit rights
- Renewal provisions
- Representations & warranties
- Governing law & jurisdiction

## Best Practices Included

- Risk-based prioritization framework
- Clause library standardization
- Cross-functional collaboration guidelines
- Counterparty due diligence checklist
- Obligation tracking systems

## Common Mistakes Addressed

- Rushing risk assessment
- Overlooking boilerplate
- Ignoring industry regulations
- Inadequate stakeholder input
- No post-signature monitoring
- Uncapped indemnification
- Vague terms
- Missing exit procedures

## Important Disclaimer

This skill provides educational analysis only. It does not constitute legal advice. For legally binding decisions, always consult with a qualified attorney.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
