---
name: dispute-resolution-clause-writer
version: 1.0.0
---

# Dispute Resolution Clause Writer - Initialization

Generate legally enforceable dispute resolution clauses with multi-tiered escalation, arbitration provisions, mediation requirements, and cross-border enforceability. Detect and remediate pathological clauses that create "disputes about disputes."

## Structure

```
dispute-resolution-clause-writer/
├── SKILL.md          # Main skill prompt (copy to AI)
├── INIT.md           # This file
└── dispute-resolution-clause-writer.zip  # Complete package
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### For Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r dispute-resolution-clause-writer/ ~/.claude/skills/dispute-resolution-clause-writer/
```

### For Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `dispute_resolution_tier_count` | `3` | Number of escalation tiers (1=direct binding, 2=negotiation+arbitration, 3=negotiation+mediation+arbitration) |
| `negotiation_period_days` | `30` | Days for initial negotiation before escalation (typical: 14-60) |
| `mediation_requirement` | `mandatory_before_binding` | Options: optional, mandatory_before_binding, concurrent, none |
| `arbitration_institution` | `AAA` | Options: AAA, ICC, LCIA, SIAC, UNCITRAL, JAMS, or litigation |
| `governing_law_jurisdiction` | `Delaware` | Jurisdiction for substantive law (Delaware, New York, English, Singapore, etc.) |
| `cost_allocation_model` | `equal_institutional_split` | Options: equal_split, loser_pays, each_bears_own, conditional, scaled_by_recovery |

## Core Capabilities

1. **Multi-Tiered Escalation Clause Generation** - Progressive dispute resolution frameworks (negotiation → mediation → arbitration)
2. **Jurisdiction & Governing Law Configuration** - Enforceable provisions for courts/arbitral forums
3. **Pathological Clause Detection & Remediation** - Fix defective dispute resolution provisions
4. **Industry-Specific Customization** - Construction, technology, international trade, healthcare, financial services, employment
5. **Enforceability Validation** - Ensure clauses meet mandatory requirements and avoid public policy violations

## Supported Contract Types

- Commercial Agreements
- Service Agreements
- Supply Contracts
- Licensing Agreements
- M&A Transactions
- Construction Contracts
- Employment Agreements
- International Trade Agreements
- Joint Ventures
- NDAs/Confidentiality Agreements

## Key Terminology

- **ADR** - Alternative Dispute Resolution (non-litigation methods)
- **Arbitration** - Binding process with final, enforceable award
- **Mediation** - Non-binding facilitated settlement process
- **Pathological Clause** - Defective provision creating "disputes about disputes"
- **New York Convention** - International treaty for arbitral award enforcement (170+ countries)
- **Carve-Out** - Exclusion of specific disputes (e.g., urgent injunctive relief)

## Example Usage

```
Generate a 3-tier dispute resolution clause for a $2.5M international
software development agreement between a US company (New York) and
German vendor. Include 30-day negotiation cooling-off, mandatory
ICDR mediation, and ICC arbitration seated in Geneva. Carve out
urgent injunctive relief.
```

## Research Sources

- [AAA ClauseBuilder](https://www.adr.org/clause-drafting/)
- [ICC Mediation Clauses](https://iccwbo.org/dispute-resolution/dispute-resolution-services/adr/mediation/mediations-clauses/)
- [SADR Guide to Drafting ADR Clauses](https://sadr.org/public/upload/pdf-files/Guide-To-Drafting-ADR-Clauses-En.pdf)
- [Sirion Dispute Resolution Clause Guide](https://www.sirion.ai/library/contract-clauses/dispute-resolution-clause/)
- [Harper James Commercial Contract Clauses](https://harperjames.co.uk/article/dispute-resolution-clauses/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
