---
name: freelance-contract-generator
version: 1.0.0
---

# Freelance Contract Generator - Initialization

Generate legally sound freelance contracts with customizable scope of work, payment terms, IP ownership, revision limits, and confidentiality clauses for designers, developers, writers, and consultants.

## Overview

This skill transforms project requirements into comprehensive freelance service agreements. It includes:

- Complete contract templates (fixed-price, retainer, change orders)
- Profession-specific addendums (designer, developer, writer, consultant)
- Industry-standard payment terms and late fee structures
- IP ownership models (work-for-hire, licensed, portfolio rights)
- Jurisdiction-aware compliance notes

## Package Structure

```
freelance-contract-generator/
├── SKILL.md          # Main skill prompt (copy to your AI assistant)
├── INIT.md           # This file - setup instructions
└── index.md          # Hugo website listing metadata
```

## Files to Generate

None - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy to Claude Code skills directory
cp -r freelance-contract-generator/ ~/.claude/skills/freelance-contract-generator/
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new Custom GPT, Gem, or Copilot instruction
4. Alternatively, paste at the start of a conversation for one-time use

### API Integration

Include the skill content as a system message:

```javascript
const messages = [
  {
    role: "system",
    content: `[Paste SKILL.md content here]`
  },
  {
    role: "user",
    content: "Generate a freelance contract for..."
  }
];
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{freelancer_name}}` | `Your Name` | Full legal name of the freelancer/contractor |
| `{{client_name}}` | `Client Company` | Legal name of the hiring entity |
| `{{project_title}}` | `Project Name` | Descriptive name of the project |
| `{{payment_structure}}` | `50/50 split` | Payment model (upfront, milestone, Net terms) |
| `{{revision_rounds}}` | `2` | Number of revision rounds included |
| `{{jurisdiction}}` | `California` | State/country governing disputes |

## Example Usage

### Basic Contract Request

```
Generate a freelance contract for a web developer building an e-commerce site.
Project value: $8,000. Payment: 40% deposit, 30% at design approval, 30% on launch.
Developer keeps portfolio rights. Client owns code upon full payment.
Include 2 revision rounds, $85/hour for extras. Late fee: 2% monthly.
Jurisdiction: New York.
```

### Retainer Agreement

```
Create a monthly retainer agreement for a marketing consultant.
20 hours/month at $4,000. Overages at $225/hour.
Services: strategy calls, campaign planning, performance reporting.
30-day termination notice. Confidentiality for 2 years.
Jurisdiction: Texas.
```

### Change Order

```
Generate a change order for project "Website Redesign" dated 2024-01-15.
Original scope: 5-page website.
New scope: Add 3 additional pages and blog section.
Additional cost: $2,400.
Timeline impact: Extends deadline by 2 weeks.
```

## Key Features

### Contract Types Supported
- Fixed-price project agreements
- Monthly retainer agreements
- Milestone-based contracts
- Change order documentation
- NDA/Confidentiality provisions

### Profession-Specific Clauses
- **Designers**: Source files, font licensing, color specs
- **Developers**: Code ownership, bug fix period, documentation
- **Writers**: Byline rights, exclusivity, kill fees
- **Consultants**: Non-compete, testimonials, referrals

### Payment Structures
- Upfront deposits (25-50%)
- Milestone payments (33-33-34, 25-25-25-25)
- Net terms (Net 7, Net 14, Net 30)
- Retainer with hourly overage
- Late fee enforcement (1.5-2% monthly)

### Legal Protections
- Scope of work with exclusions
- Revision limits and overage rates
- IP ownership and portfolio rights
- Confidentiality clauses
- Termination procedures
- Independent contractor status
- Force majeure provisions

## Best Practices

1. **Be Specific About Scope** - "5 blog posts, 1000 words each" not "content"
2. **Use Milestone Payments** - For projects over $5,000
3. **Set Net 14 Terms** - Balances cash flow and client convenience
4. **Limit Revisions** - 2-3 rounds included; charge for extras
5. **Document Exclusions** - What you WON'T do is as important as what you will
6. **Include Late Fees** - Clients respect contracts with enforcement
7. **Specify IP Clearly** - Who owns what and when

## Disclaimer

**IMPORTANT**: This skill generates contract templates for educational and starting-point purposes only. For contracts exceeding $50,000, involving complex intellectual property, or requiring jurisdiction-specific compliance, consult a qualified attorney. This is not legal advice.

## Related Skills

- [Contract Reviewer](/skills/productivity/contract-reviewer/) - Analyze existing contracts
- [Invoice Generator](/skills/productivity/invoice-generator/) - Create professional invoices
- [Invoice Chaser](/skills/solopreneur/invoice-chaser/) - Follow up on overdue payments
- [Negotiation Stance Builder](/skills/productivity/negotiation-stance-builder/) - Prepare for negotiations

---

Downloaded from [Find Skill.ai](https://findskill.ai)
