---
name: licensing-agreement-architect
version: 1.0.0
---

# Licensing Agreement Architect - Initialization

Draft comprehensive licensing agreements for patents, software, trademarks, copyrights, and trade secrets. Generate grant of license clauses, royalty structures, exclusivity terms, quality control provisions, and termination mechanics with industry-standard language.

## Package Contents

```
licensing-agreement-architect/
├── SKILL.md    # Main skill prompt (comprehensive drafting guide)
└── INIT.md     # This initialization file
```

## Structure

- `SKILL.md` - Complete licensing agreement drafting skill with:
  - 7 core capabilities (Grant of License, Royalty Structure, Exclusivity Framework, Quality Control, IP Improvements, Termination Mechanics, Open Source Selection)
  - 16 key concepts and terminology definitions
  - 5 detailed workflows (Patent, SaaS, Franchise, Open Source, Content)
  - Best practices (7 do's, 6 don'ts)
  - Troubleshooting for 6 common edge cases
  - 3 comprehensive agreement structure templates

## Files to Generate

None required (prompt-only skill)

## Installation

### Claude Code (Recommended)

```bash
# Create skills directory if needed
mkdir -p ~/.claude/skills

# Copy skill to Claude Code skills directory
cp -r licensing-agreement-architect/ ~/.claude/skills/licensing-agreement-architect/

# Verify installation
ls ~/.claude/skills/licensing-agreement-architect/
```

### Claude Desktop / Claude.ai

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (starting from `# LICENSING AGREEMENT ARCHITECT`)
3. Start a new conversation in Claude
4. Paste the skill content as your first message
5. Claude will acknowledge the skill and begin using it

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter
3. Create a new Custom GPT or paste into conversation
4. For Custom GPT: Use as the Instructions field
5. For conversation: Paste as the first message

### Gemini / Other Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter
3. Paste into your AI assistant as context or instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `ip_type` | `software` | Type of IP: patent, software, trademark, copyright, trade_secret, franchise |
| `exclusivity_model` | `non_exclusive` | License model: exclusive, non_exclusive, sole |
| `royalty_rate_percent` | `5.0` | Royalty percentage (typical 2-7% for manufacturing, 10-25% for software) |
| `minimum_annual_guarantee` | `50000` | Minimum payment regardless of sales |
| `license_term_years` | `3` | Duration in years (or "perpetual") |
| `territory_scope` | `worldwide` | Geographic scope |
| `support_required` | `false` | Whether licensor provides support |
| `ip_improvement_ownership` | `shared` | Who owns improvements |

## Example Usage

### Patent Licensing
```
I have a patent for a manufacturing process. I want to license it to
3 manufacturers in different regions (NA, EU, APAC) exclusively by region.
Looking for $100K upfront per region, 3% royalty, $250K annual minimum.
What terms am I missing?
```

### SaaS Agreement
```
I'm licensing our API platform to an enterprise customer. Need:
- 3-year subscription, non-exclusive
- $100K annual minimum + 5% revenue share
- 99.9% SLA uptime guarantees
- Quarterly audit rights

Help me draft Grant of License, Restrictions, Payment Terms,
Support SLA, Audit Rights, and Termination sections.
```

### Open Source License Selection
```
I'm releasing an AI library on GitHub. Want maximum adoption by
commercial companies but also want patent protection. Comparing
MIT vs Apache 2.0 vs LGPL. Dependencies include MIT and BSD code.
What license should I use and how do I document it?
```

## Key Features

1. **Multi-IP Coverage**: Patents, software, trademarks, copyrights, trade secrets, franchises
2. **Industry Benchmarks**: Royalty rates by IP type and industry
3. **Complete Workflows**: Step-by-step for 5 licensing scenarios
4. **Agreement Templates**: Full structures for patent, SaaS, and franchise agreements
5. **Risk Mitigation**: Quality control, termination, bankruptcy, and infringement provisions
6. **Open Source Guidance**: License selection, compatibility matrix, repository setup

## Related Skills

- **Licensing & Royalty Negotiator** - Negotiate optimal deal terms and royalty rates
- **IP Assignment Writer** - Transfer IP ownership (vs. licensing)
- **Contract Analyzer** - Review existing agreements for risks
- **NDA Generator** - Protect confidential info during negotiations

## Disclaimer

This skill provides educational guidance on licensing agreement concepts. Not legal advice. Consult qualified legal counsel before executing any agreement.

---

Downloaded from [Find Skill.ai](https://findskill.ai)
