---
name: refund-policy-drafter
version: 1.0.0
---

# Refund Policy Drafter - Initialization

Create legally compliant refund policies that balance consumer protection with business sustainability across US (ROSCA), EU, UK, and international jurisdictions.

## What This Skill Does

- Generates multi-jurisdiction compliant refund policies (US, EU, UK, CA, AU)
- Provides templates for e-commerce, SaaS subscriptions, and digital products
- Includes FTC Click-to-Cancel (2024) compliance language
- Adds chargeback prevention clauses and consent documentation
- Distinguishes between buyer's remorse and defect claims
- Calculates prorated refund formulas for subscriptions

## Structure

```
refund-policy-drafter/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code / Claude Desktop

```bash
# Copy to your skills directory
cp -r refund-policy-drafter/ ~/.claude/skills/refund-policy-drafter/
```

Add to your CLAUDE.md or system prompt:
```
When drafting refund policies, use the refund-policy-drafter skill.
```

### ChatGPT / Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter
3. Paste into your AI assistant as the system prompt or first message
4. Provide your business details when prompted

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{return_window_days}}` | `30` | Number of days customers have to initiate returns |
| `{{jurisdiction}}` | `US` | Primary legal jurisdiction (US, EU, UK, CA, AU) |
| `{{product_type}}` | `physical_goods` | Type of product (physical_goods, digital_product, saas_subscription, service) |
| `{{defect_window_days}}` | `180` | Extended window for defect/quality claims |
| `{{restocking_fee_percent}}` | `0` | Percentage fee for non-defect returns (0-20%) |
| `{{shipping_cost_allocation}}` | `customer_pays` | Who pays return shipping (customer_pays, prepaid_label, seller_pays) |

## Example Usage

**For E-Commerce Store:**
```
I'm launching a Shopify store selling eco-friendly home goods. I want a
30-day return policy that protects me from scammers but doesn't scare
away customers. US customers only. Who pays shipping?
```

**For SaaS Product:**
```
I'm offering a $99/month project management SaaS with annual option.
I need 30-day money-back guarantee compliant with ROSCA, FTC Click-to-Cancel,
and EU Cooling-Off for EU customers. Include prorated refunds.
```

**For Digital Courses:**
```
I sell online courses ($197) via my website. Need a refund policy allowing
refunds for 14 days if customer hasn't accessed more than 20% of content.
EU customers need cooling-off compliance.
```

## Key Legal Frameworks Covered

| Framework | Jurisdiction | Key Requirement |
|-----------|--------------|-----------------|
| ROSCA | US | Clear disclosure, consent, easy cancellation |
| Click-to-Cancel | US (2024) | Online cancellation if online sign-up |
| Consumer Rights Directive | EU | 14-day non-waivable cooling-off |
| Digital Content Directive | EU | 2-year conformity, burden of proof |
| Consumer Rights Act 2015 | UK | 30-day reject right, 6-month burden |
| Australian Consumer Law | AU | No restocking fees on defects |
| Consumer Protection Act | CA | Provincial disclosure requirements |

## Compliance Checklist

Before deploying your generated policy:

- [ ] Cooling-off period meets jurisdiction minimums
- [ ] Defect window exceeds buyer's remorse window
- [ ] Click-to-cancel implemented for subscriptions
- [ ] Consent documentation at checkout
- [ ] Version tracking enabled
- [ ] Contact information prominentRelated Skills

- Privacy Policy Generator - GDPR/CCPA compliant privacy policies
- Terms of Service Generator - Liability protections and user guidelines
- Contract Reviewer - Analyze contracts for red flags
- Non-Compete Loophole Finder - Employment contract analysis

---
Downloaded from [Find Skill.ai](https://findskill.ai)
