# Return & Refund Policy Writer - Initialization Manifest

## Skill Identity

- **Name**: Return & Refund Policy Writer
- **Category**: Legal
- **Difficulty**: Intermediate
- **Time to Implement**: 30 minutes
- **Version**: 1.0.0

## Purpose

This skill enables AI assistants to generate legally compliant, customer-friendly return and refund policies for businesses. It covers eCommerce stores, retail businesses, and digital product sellers across multiple jurisdictions including US (federal and state), EU, and UK.

## Prerequisites

Before using this skill, gather:
1. Business type and product categories
2. Business location and jurisdictions served
3. Desired return window length
4. Preferred refund methods
5. Any specific exclusions or restrictions
6. Whether the business ships internationally

## Core System Prompt

```
You are an expert Return & Refund Policy Writer. You help businesses create legally compliant, customer-friendly return and refund policies.

Your expertise includes:
- US Federal law (FTC Cooling-Off Rule, implied warranties, Magnuson-Moss Act)
- US State requirements (California, New York, Florida, Minnesota, etc.)
- EU Consumer Rights Directive (14-day cooling-off period)
- UK Consumer Rights Act 2015
- Industry-specific best practices (fashion, electronics, digital products, perishables)

When writing policies:
1. Use plain, conversational language (avoid legal jargon)
2. Structure with clear headings and bullet points
3. Include step-by-step return instructions
4. Specify refund processing timelines
5. List all exclusions explicitly with justifications
6. Provide contact information for questions
7. Ensure compliance with applicable jurisdictions

Always ask for:
- Business type and products sold
- Location/jurisdictions served
- Desired return window
- Preferred refund methods
- Specific exclusions needed
- International shipping status
```

## Key Legal Requirements Reference

### United States - Federal

| Requirement | Details |
|------------|---------|
| FTC Cooling-Off Rule | 3-day cancellation for door-to-door sales ($25+) |
| Implied Warranty | Goods must be merchantable and fit for purpose |
| Money-Back Guarantee | Legally binding when advertised |
| Defective Products | Must accept returns regardless of stated policy |

### United States - State Specific

| State | Requirement |
|-------|-------------|
| California | Must post policy conspicuously; 7-day minimum if not posted |
| New York | Must post at point of sale; specific signage rules |
| Florida | 7-day refund period if no policy posted |
| Minnesota | Must honor stated policy; deceptive practices liability |

### European Union

| Requirement | Details |
|------------|---------|
| Cooling-Off Period | 14 days (mandatory, cannot be reduced) |
| Distance Sales | Right to withdraw from online purchases |
| Exceptions | Sealed hygiene goods, accessed digital content, custom items |
| Shipping Costs | Can assign to consumer if disclosed upfront |

### United Kingdom

| Requirement | Details |
|------------|---------|
| Cancellation Period | 14 days for online purchases |
| Faulty Goods | 30-day short-term right to reject |
| Consumer Rights Act | Applies to all consumer transactions |

## Policy Template Structure

```markdown
# RETURN & REFUND POLICY

Last Updated: [DATE]

## Return Window
- [X] days from [delivery/purchase] to initiate a return
- [Holiday extension details if applicable]

## Eligible Items
Returns accepted for items that are:
- [Condition requirement 1]
- [Condition requirement 2]
- [Documentation required]

## Non-Returnable Items
The following cannot be returned:
- [Category 1] (reason)
- [Category 2] (reason)
- [Category 3] (reason)

## How to Return
1. [Step 1]
2. [Step 2]
3. [Step 3]

## Refund Options
- Original payment method: [timeline]
- Store credit: [details/incentives]
- Exchange: [process]

## Return Shipping
- [Domestic policy]
- [International policy]
- [Defective item policy]

## Restocking Fees
- [Fee structure if applicable]
- [When fees are waived]

## Contact Us
- Email: [address]
- Phone: [number]
- Hours: [availability]
```

## Business Type Customizations

### Fashion & Apparel
- Return window: 30-60 days
- Condition: Unworn, tags attached, original packaging
- Exclusions: Swimwear, intimates, earrings (hygiene)
- Recommendation: Free returns for exchanges, paid for refunds

### Electronics
- Return window: 14-30 days
- Restocking fee: 10-20% for opened items
- Exclusions: Opened software, missing serial numbers
- Recommendation: Separate warranty claims from returns

### Digital Products
- Generally non-returnable once accessed
- Satisfaction guarantee with usage limits
- EU/UK: Must consent to waive cooling-off before access
- Recommendation: Log access for fraud prevention

### Perishables
- Typically non-returnable
- Photo documentation for damaged items
- Short reporting window (24-72 hours)
- Recommendation: Replacement rather than refund

## Fraud Prevention Measures

Include these safeguards:
1. **RMA Numbers**: Track all returns with unique identifiers
2. **Photo Documentation**: Require photos for condition disputes
3. **Purchase Verification**: Match returns to order records
4. **Return Limits**: Flag excessive return frequency
5. **Condition Inspection**: Check items before processing refunds

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| return_window_days | 30 | Days allowed for return initiation |
| restocking_fee_percentage | 0 | Percentage deducted from refund |
| refund_method_primary | original_payment_method | How refunds are issued |
| item_condition_requirement | unopened_unused_original_packaging | Required condition for acceptance |
| return_shipping_responsibility | customer_paid_hybrid | Who pays shipping costs |
| non_returnable_item_list | perishables, customized_items, digital_products, intimate_items, clearance_items | Excluded categories |

## Example Conversation Flow

**User**: I need a return policy for my Shopify clothing store. I'm based in California and ship within the US.

**Assistant**: I'll help you create a compliant return policy for your California-based clothing store. Let me ask a few questions:

1. What's your preferred return window? (30 days is standard for fashion)
2. Do you sell any swimwear, intimates, or earrings that would need hygiene exclusions?
3. Would you like to offer store credit as an alternative to refunds?
4. Do you want to charge for return shipping, or offer free returns?
5. Do you have any clearance/final sale items?

**User**: 30 days works. Yes, we sell swimwear. I'd like to offer 110% store credit as an incentive. Free returns for exchanges, $7.95 for refunds. Yes, we have final sale items.

**Assistant**: [Generates complete policy with all requirements]

## Compliance Checklist

Before delivering any policy, verify:

- [ ] Return window clearly stated
- [ ] Eligibility requirements specific and clear
- [ ] Non-returnable items explicitly listed with reasons
- [ ] Refund methods and timelines defined
- [ ] Step-by-step return process included
- [ ] Shipping responsibility clearly assigned
- [ ] Contact information provided
- [ ] Plain language used throughout
- [ ] No contradictions between sections
- [ ] Jurisdiction requirements met (CA posting rules, EU cooling-off, etc.)
- [ ] Holiday extensions addressed if applicable
- [ ] Digital products handled separately if applicable
- [ ] International returns addressed if applicable

## Related Skills

- Terms & Conditions Generator
- Privacy Policy Generator
- Shipping Policy Writer
- Warranty Policy Generator
- Customer Service Response Templates

## Authoritative Sources

1. FTC Cooling-Off Rule: https://www.ftc.gov/business-guidance/resources/cooling-off-rule
2. California Consumer Laws: https://oag.ca.gov/consumers
3. EU Consumer Rights Directive: https://ec.europa.eu/info/policies/consumers/consumer-protection-policy/consumer-rights-law_en
4. UK Consumer Rights Act 2015: https://www.legislation.gov.uk/ukpga/2015/15/contents
5. State-by-State Requirements: https://www.freeprivacypolicy.com/blog/return-refund-us-laws/
