---
name: wage-hour-compliance-checker
version: 1.0.0
---

# Initialization

The Wage & Hour Compliance Checker audits employment practices for violations of the Fair Labor Standards Act (FLSA) and state wage laws. It identifies employee misclassification, overtime calculation errors, time-tracking gaps, and multi-state compliance issues while calculating back-pay exposure.

## Structure

- `SKILL.md` - Main skill prompt with complete compliance audit framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r wage-hour-compliance-checker/ ~/.claude/skills/wage-hour-compliance-checker/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{jurisdiction_list}}` | `US_Federal` | States/jurisdictions to check (e.g., CA, NY, TX) |
| `{{audit_period}}` | `last_12_months` | Time period to analyze |
| `{{employee_sample_size}}` | `25%` | Percentage of employees to audit in detail |
| `{{industry_type}}` | `general_business` | Industry for violation pattern analysis |
| `{{time_tracking_system}}` | `manual_timesheets` | Current timekeeping method |
| `{{risk_tolerance}}` | `conservative` | Classification approach |

## Core Capabilities

1. **Employee Classification Audits** - Verify exempt vs. non-exempt status using FLSA three-part test
2. **Time-Tracking Validation** - Identify off-the-clock work, unpaid breaks, rounding errors
3. **Overtime Compliance Analysis** - Calculate proper overtime rates including bonuses/commissions
4. **Break & Meal Period Audits** - Flag violations of federal and state break rules
5. **State Law Integration** - Cross-reference federal FLSA with state/local wage laws
6. **Back-Pay Exposure Calculator** - Quantify liability with penalty multipliers

## Example Usage

```
"We're a California retail company with 85 employees, including 12 salaried
managers at $52,000/year who work 50+ hours weekly doing mostly cashier
and stocking work. They're classified as exempt. Are we compliant with
wage and hour laws? What's our exposure?"
```

## Key Concepts

- **FLSA Three-Part Test**: Salary level ($684/wk), salary basis, job duties
- **Regular Rate**: Base wage + nondiscretionary bonuses for OT calculation
- **State Daily Overtime**: California requires OT after 8 hours/day
- **Lookback Period**: 2-3 years federal, up to 4 years in California
- **Liquidated Damages**: Up to 100% of back wages as penalty

---
Downloaded from [Find Skill.ai](https://findskill.ai)
