---
name: mcp-custom-server-builder
version: 1.0.0
description: Build production-ready custom MCP servers in Python or TypeScript with tools, resources, and prompts
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you build custom MCP servers from scratch. Covers both Python (FastMCP) and TypeScript (official SDK) approaches, including tool/resource/prompt definitions, transport configuration, testing with MCP Inspector, and Docker deployment.

**Time to initialize**: ~5 minutes

## Directory Structure

```
mcp-custom-server-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Building MCP servers requires:

**Python path:**
- Python 3.11+
- `pip install fastmcp` (or `pip install mcp` for official SDK)
- Optional: `httpx` for async HTTP, Docker for deployment

**TypeScript path:**
- Node.js 18+
- `npm install @modelcontextprotocol/sdk zod`
- Optional: Express for HTTP transport, Docker for deployment

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Python Setup

```bash
mkdir my-mcp-server && cd my-mcp-server
python3 -m venv venv
source venv/bin/activate
pip install fastmcp
```

### TypeScript Setup

```bash
mkdir my-mcp-server && cd my-mcp-server
npm init -y
npm install @modelcontextprotocol/sdk zod
npm install -D typescript @types/node
npx tsc --init
```

### Testing

```bash
# Test with MCP Inspector
npx @modelcontextprotocol/inspector fastmcp run server.py
# Or for TypeScript
npx @modelcontextprotocol/inspector node dist/server.js
```

## Compatibility

Tested with: Claude Desktop, Claude Code, Cursor, VS Code Copilot, Windsurf

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{server_purpose}}` | `connecting my AI assistant to internal APIs and databases` | Primary purpose |
| `{{language}}` | `Python with FastMCP` | Preferred language |
| `{{transport}}` | `stdio for local, Streamable HTTP for remote` | Transport mechanism |
| `{{deployment_target}}` | `Docker container` | Deployment target |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
