---
name: mcp-github-integration
version: 1.0.0
description: Connect AI assistants to GitHub via MCP for managing repos, issues, PRs, code search, Actions workflows, and security alerts
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you set up the GitHub MCP Server to connect AI assistants (Claude, ChatGPT, Copilot) to GitHub's platform. Once configured, you can use natural language to manage repositories, issues, pull requests, CI/CD workflows, and security alerts.

**Time to initialize**: ~2 minutes (prompt-only skill)

## Directory Structure

```
mcp-github-integration/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). The GitHub MCP Server itself requires:
- Docker (for self-hosted deployment) OR
- Network access to `https://api.githubcopilot.com/mcp/` (for remote deployment)
- GitHub Personal Access Token (PAT)

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Post-Init Steps

### Claude Desktop
1. Open SKILL.md and copy the content after the frontmatter
2. Configure the GitHub MCP server in your Claude Desktop config:

**macOS**: `~/Library/Application Support/Claude/claude_desktop_config.json`
**Windows**: `%APPDATA%\Claude\claude_desktop_config.json`

```json
{
  "mcpServers": {
    "github": {
      "type": "http",
      "url": "https://api.githubcopilot.com/mcp/",
      "headers": {
        "Authorization": "Bearer YOUR_GITHUB_PAT"
      }
    }
  }
}
```

### Claude Code
```bash
claude mcp add-json github '{
  "type": "http",
  "url": "https://api.githubcopilot.com/mcp/",
  "headers": {
    "Authorization": "Bearer YOUR_GITHUB_PAT"
  }
}'
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude Desktop, Claude Code, VS Code Copilot, Cursor, Windsurf

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{github_workflow}}` | `managing issues and pull requests` | Primary workflow to assist with |
| `{{repo_scope}}` | `my-org/my-repo` | Repositories for AI to access |
| `{{toolsets}}` | `repos,issues,pull_requests,actions` | Enabled toolsets |
| `{{access_level}}` | `read-write` | Access level (read-only or read-write) |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
