---
name: mcp-google-drive-connector
version: 1.0.0
description: Connect AI assistants to Google Drive via MCP for searching files, creating Docs/Sheets/Slides, and managing folders
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you set up a Google Drive MCP Server to connect AI assistants to Google Drive, Google Docs, Google Sheets, and Google Slides. Supports the comprehensive @piotr-agier/google-drive-mcp (20+ tools) and the official reference server (read-only).

**Time to initialize**: ~5 minutes

## Directory Structure

```
mcp-google-drive-connector/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). The Google Drive MCP Server requires:
- Node.js 18+ (for NPX-based servers)
- Google Cloud Project with OAuth 2.0 credentials
- Google Drive, Docs, Sheets, and Slides APIs enabled

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Step 1: Google Cloud Project Setup

1. Go to https://console.cloud.google.com
2. Create a new project (e.g., "Google Drive MCP")
3. Enable these APIs:
   - Google Drive API
   - Google Docs API
   - Google Sheets API
   - Google Slides API
4. Go to OAuth consent screen → configure as External
5. Create OAuth 2.0 credentials:
   - Type: **Desktop app**
   - Download JSON → rename to `gcp-oauth.keys.json`

### Step 2: Configure MCP Client

#### Option A: Comprehensive Server (Recommended)

**Claude Desktop** (`~/Library/Application Support/Claude/claude_desktop_config.json`):
```json
{
  "mcpServers": {
    "google-drive": {
      "command": "npx",
      "args": ["@piotr-agier/google-drive-mcp"],
      "env": {
        "GOOGLE_DRIVE_OAUTH_CREDENTIALS": "/path/to/gcp-oauth.keys.json"
      }
    }
  }
}
```

**Claude Code**:
```bash
claude mcp add-json google-drive '{
  "command": "npx",
  "args": ["@piotr-agier/google-drive-mcp"],
  "env": {
    "GOOGLE_DRIVE_OAUTH_CREDENTIALS": "/path/to/gcp-oauth.keys.json"
  }
}'
```

#### Option B: Official Reference Server

```json
{
  "mcpServers": {
    "gdrive": {
      "command": "npx",
      "args": ["-y", "@modelcontextprotocol/server-gdrive"],
      "env": {
        "CLIENT_ID": "your-oauth-client-id",
        "CLIENT_SECRET": "your-oauth-client-secret",
        "GDRIVE_CREDS_DIR": "/path/to/credentials"
      }
    }
  }
}
```

### Step 3: Authenticate

On first run, a browser window opens for OAuth. Sign in with your Google account and grant permissions. The token is stored at `~/.config/google-drive-mcp/tokens.json`.

## Compatibility

Tested with: Claude Desktop, Claude Code, Cursor, VS Code Copilot, Windsurf

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{drive_workflow}}` | `searching files and creating documents` | Primary workflow |
| `{{file_types}}` | `Docs, Sheets, and Slides` | File types used most |
| `{{folder_scope}}` | `My Drive root and shared folders` | Folders to access |
| `{{access_level}}` | `read and write` | Access level |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
