---
name: mcp-multi-server-orchestrator
version: 1.0.0
description: Orchestrate multiple MCP servers into unified AI workflows with gateway patterns and intelligent routing
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you design and deploy multi-server MCP orchestration systems. Covers gateway patterns, tool namespacing, cross-server workflows, circuit breakers, and Docker/Kubernetes deployment.

**Time to initialize**: ~5 minutes

## Directory Structure

```
mcp-multi-server-orchestrator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Building orchestration layers requires:
- Python 3.11+ with FastMCP (for gateway servers)
- Docker and Docker Compose (for multi-container deployment)
- Optional: Kubernetes for production scaling

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Gateway Setup

```bash
# Create gateway project
mkdir mcp-gateway && cd mcp-gateway
python3 -m venv venv
source venv/bin/activate
pip install fastmcp httpx structlog
```

### Docker Compose for Multi-Server

Create `docker-compose.yml` with gateway + backend servers, then:
```bash
docker compose up -d
```

### Testing

```bash
# Test gateway with MCP Inspector
npx @modelcontextprotocol/inspector fastmcp run gateway.py
```

## Compatibility

Tested with: Claude Desktop, Claude Code, Cursor, VS Code Copilot, Windsurf

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{server_count}}` | `3-5 specialized servers` | Number of servers |
| `{{orchestration_pattern}}` | `gateway with intelligent routing` | Orchestration approach |
| `{{deployment_env}}` | `Docker Compose for development, Kubernetes for production` | Deployment target |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
