---
name: mcp-notion-bridge
version: 1.0.0
description: Connect AI assistants to Notion workspaces via MCP for pages, databases, blocks, and comments
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you set up the official Notion MCP Server to connect AI assistants to your Notion workspace. Once configured, you can use natural language to search pages, query databases, create content, and manage your knowledge base.

**Time to initialize**: ~5 minutes (includes Notion integration setup)

## Directory Structure

```
mcp-notion-bridge/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). The Notion MCP Server requires:
- Node.js 18+ (for NPX) OR Docker
- A Notion Internal Integration Token (`ntn_...`)

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### 1. Create Notion Integration
1. Go to https://www.notion.so/profile/integrations
2. Click "New integration" → name it → select workspace
3. Set capabilities: Read content, Update content, Insert content
4. Copy the token (starts with `ntn_`)

### 2. Connect Integration to Pages
For each page/database: "..." menu → "Connect to" → Your Integration

### 3. Configure MCP Client

**Claude Desktop**:
```json
{
  "mcpServers": {
    "notionApi": {
      "command": "npx",
      "args": ["-y", "@notionhq/notion-mcp-server"],
      "env": {
        "NOTION_TOKEN": "ntn_your_token"
      }
    }
  }
}
```

**Claude Code**:
```bash
claude mcp add-json notionApi '{"command":"npx","args":["-y","@notionhq/notion-mcp-server"],"env":{"NOTION_TOKEN":"ntn_your_token"}}'
```

## Compatibility

Tested with: Claude Desktop, Claude Code, Cursor, VS Code Copilot, ChatGPT

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{notion_workflow}}` | `searching and creating documentation pages` | Primary workflow |
| `{{workspace_scope}}` | `Engineering Wiki, Product Roadmap, Meeting Notes` | Accessible content |
| `{{access_level}}` | `read and write` | Permission level |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
